/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.core.Mergeable;
import adams.data.container.DataContainer;
import adams.data.filter.AbstractFilter;
import adams.data.noise.AbstractDenoiser;
import adams.data.noise.PassThrough;
import java.util.Vector;

public class RemoveNoise<T extends DataContainer & Mergeable>
extends AbstractFilter<T> {
    private static final long serialVersionUID = 4225773526265205077L;
    protected AbstractDenoiser m_Denoiser;
    protected boolean m_Invert;

    @Override
    public String globalInfo() {
        return "A filter that removes noise from the data with a user-supplied noise level algorithm.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("denoiser", "denoiser", new PassThrough());
        this.m_OptionManager.add("invert", "invert", false);
    }

    public void setDenoiser(AbstractDenoiser value) {
        this.m_Denoiser = value;
        this.m_Denoiser.setRecordRegions(true);
        this.reset();
    }

    public AbstractDenoiser getDenoiser() {
        return this.m_Denoiser;
    }

    public String denoiserTipText() {
        return "The denoiser algorithm to use for removing the noise from the data.";
    }

    public void setInvert(boolean value) {
        this.m_Invert = value;
        this.reset();
    }

    public boolean getInvert() {
        return this.m_Invert;
    }

    public String invertTipText() {
        return "If set to true, non-noise will be removed instead of noise.";
    }

    @Override
    protected T processData(T data) {
        AbstractDenoiser denoiser = this.m_Denoiser.shallowCopy(true);
        denoiser.setRecordRegions(true);
        Object result = denoiser.denoise(data);
        if (this.m_Invert) {
            result = result.getHeader();
            Vector regions = denoiser.getRegions();
            for (int i = 0; i < regions.size(); ++i) {
                result.mergeWith(regions.get(i));
            }
        }
        denoiser.destroy();
        if (this.isDebugOn()) {
            this.debug("Number of points: input=" + data.size() + ", output=" + result.size());
        }
        return (T)result;
    }
}

