/*
 * Decompiled with CFR 0.152.
 */
package adams.env;

import adams.core.Mergeable;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Vector;

public class Setup
implements Serializable,
Comparable,
Mergeable<Setup> {
    private static final long serialVersionUID = 4280435277797929265L;
    protected String m_PropertiesFile;
    protected Vector<String> m_Directories;
    protected Vector<String> m_Overrides;

    public Setup(String props, Vector<String> dirs) {
        this(props, dirs, new String[0]);
    }

    public Setup(String props, Vector<String> dirs, String[] overrides) {
        this.m_PropertiesFile = props;
        this.m_Directories = new Vector<String>(dirs);
        this.m_Overrides = new Vector();
        if (overrides != null) {
            for (int i = 0; i < overrides.length; ++i) {
                this.m_Overrides.add(overrides[i]);
            }
        }
    }

    public String getPropertiesFile() {
        return this.m_PropertiesFile;
    }

    public String getFilename() {
        return this.m_PropertiesFile.replaceAll(".*\\/", "");
    }

    public Vector<String> getDirectories() {
        return this.m_Directories;
    }

    public boolean hasOverrides() {
        return this.m_Overrides.size() > 0;
    }

    public Vector<String> getOverrides() {
        return this.m_Overrides;
    }

    @Override
    public void mergeWith(Setup other) {
        if (this.getFilename().equals(other.getFilename())) {
            HashSet<String> cache = new HashSet<String>(this.m_Directories);
            for (String dir : other.getDirectories()) {
                if (cache.contains(dir)) continue;
                this.m_Directories.add(dir);
            }
            cache = new HashSet<String>(this.m_Overrides);
            for (String override : other.getOverrides()) {
                if (cache.contains(override)) continue;
                this.m_Overrides.add(override);
            }
        }
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        if (!(o instanceof Setup)) {
            return -1;
        }
        Setup other = (Setup)o;
        return this.m_PropertiesFile.compareTo(other.m_PropertiesFile);
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public String toString() {
        String result = this.m_PropertiesFile + ": Directories=" + this.m_Directories;
        if (this.m_Overrides.size() > 0) {
            result = result + ", Overrides=" + this.m_Overrides;
        }
        return result;
    }
}

