/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.processor;

import adams.core.VariableName;
import adams.core.option.AbstractArgumentOption;
import adams.flow.processor.AbstractNameUpdater;

public class UpdateVariableName
extends AbstractNameUpdater<VariableName> {
    private static final long serialVersionUID = -5355023022079902959L;

    @Override
    public String globalInfo() {
        return "Updates all occurrences of the old variable name with the new one.";
    }

    @Override
    public String oldNameTipText() {
        return "The old variable name to replace with the new one.";
    }

    @Override
    public String newNameTipText() {
        return "The new variable name that replaces the old one.";
    }

    @Override
    protected boolean isBaseClassMatch(Class cls) {
        return cls.equals(VariableName.class);
    }

    @Override
    protected boolean isNameMatch(VariableName old, String oldName) {
        return old.getValue().equals(oldName);
    }

    @Override
    protected VariableName getReplacement(VariableName old, String newName) {
        return new VariableName(newName);
    }

    @Override
    protected void processArgumentOption(AbstractArgumentOption option) {
        super.processArgumentOption(option);
        if (option.isVariableAttached() && option.getVariableName().equals(this.m_OldName)) {
            option.setVariable(this.m_NewName);
            this.m_Modified = true;
        }
    }
}

