/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font.afm;

import de.intarsys.cwt.font.afm.AFMChar;
import de.intarsys.cwt.font.afm.AFMParser;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class AFM {
    public static final String ATTR_FontName = "FontName";
    private ILocator locator;
    private Map<Integer, AFMChar> charsByCode = new HashMap<Integer, AFMChar>();
    private Map<String, AFMChar> charsByName = new HashMap<String, AFMChar>();
    private Map<String, String> attributes = new HashMap<String, String>();

    public static AFM createFromLocator(ILocator locator) throws IOException {
        AFM result = new AFM();
        result.setLocator(locator);
        result.initializeFromLocator();
        return result;
    }

    public static AFM createNew() {
        return new AFM();
    }

    protected AFM() {
    }

    protected void addChar(AFMChar c) {
        if (c.getCode() != -1) {
            this.charsByCode.put(new Integer(c.getCode()), c);
        }
        if (c.getName() != null) {
            this.charsByName.put(c.getName(), c);
        }
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public AFMChar getCharByCode(int codePoint) {
        return this.charsByCode.get(new Integer(codePoint));
    }

    public AFMChar getCharByName(String name) {
        return this.charsByName.get(name);
    }

    public String getFontName() {
        return this.getAttribute(ATTR_FontName);
    }

    public ILocator getLocator() {
        return this.locator;
    }

    protected void initializeFromLocator() throws IOException {
        IRandomAccess random = null;
        try {
            random = this.getLocator().getRandomAccess();
            AFMParser parser = new AFMParser(this);
            parser.parse(random);
        }
        finally {
            StreamTools.close((IRandomAccess)random);
        }
    }

    protected void setAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    protected void setLocator(ILocator locator) {
        this.locator = locator;
    }
}

