/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.html;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.WritableDirectElement;
import com.itextpdf.text.log.Level;
import com.itextpdf.text.log.Logger;
import com.itextpdf.text.log.LoggerFactory;
import com.itextpdf.text.pdf.PdfDestination;
import com.itextpdf.text.pdf.PdfOutline;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.tool.xml.NoCustomContextException;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.css.apply.ChunkCssApplier;
import com.itextpdf.tool.xml.exceptions.LocaleMessages;
import com.itextpdf.tool.xml.html.AbstractTagProcessor;
import com.itextpdf.tool.xml.html.HTMLUtils;
import com.itextpdf.tool.xml.html.HeaderNode;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Header
extends AbstractTagProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Header.class);

    @Override
    public List<Element> content(WorkerContext ctx, Tag tag, String content) {
        String sanitized = HTMLUtils.sanitizeInline(content);
        ArrayList<Element> l = new ArrayList<Element>(1);
        if (sanitized.length() > 0) {
            l.add((Element)new ChunkCssApplier().apply(new Chunk(sanitized), tag));
        }
        return l;
    }

    @Override
    public List<Element> end(WorkerContext ctx, final Tag tag, List<Element> currentContent) {
        ArrayList<Element> l = new ArrayList<Element>(1);
        if (currentContent.size() > 0) {
            List<Element> currentContentToParagraph;
            block5: {
                currentContentToParagraph = this.currentContentToParagraph(currentContent, true, true, tag, ctx);
                try {
                    final HtmlPipelineContext context = this.getHtmlPipelineContext(ctx);
                    if (context.autoBookmark()) {
                        final Paragraph title = new Paragraph();
                        for (Element w : currentContentToParagraph) {
                            title.add(w);
                        }
                        l.add((Element)new WritableDirectElement(){

                            public void write(PdfWriter writer, Document doc) throws DocumentException {
                                PdfDestination destination = new PdfDestination(0, 20.0f, writer.getVerticalPosition(false), 0.0f);
                                Map<String, Object> memory = context.getMemory();
                                HeaderNode tree = (HeaderNode)memory.get("header.autobookmark.RootNode");
                                int level = Header.this.getLevel(tag);
                                if (null == tree) {
                                    tree = new HeaderNode(0, writer.getRootOutline(), null);
                                } else {
                                    int lastLevel = tree.level();
                                    if (lastLevel == level) {
                                        tree = tree.parent();
                                    } else if (lastLevel > level) {
                                        while (lastLevel >= level) {
                                            lastLevel = tree.parent().level();
                                            tree = tree.parent();
                                        }
                                    }
                                }
                                if (LOGGER.isLogging(Level.TRACE)) {
                                    LOGGER.trace(String.format(LocaleMessages.getInstance().getMessage("html.tag.h.create"), title.toString()));
                                }
                                HeaderNode node = new HeaderNode(level, new PdfOutline(tree.outline(), destination, title), tree);
                                memory.put("header.autobookmark.RootNode", node);
                            }
                        });
                    }
                }
                catch (NoCustomContextException e) {
                    if (!LOGGER.isLogging(Level.ERROR)) break block5;
                    LOGGER.error(LocaleMessages.getInstance().getMessage("html.tag.h.disabled"), (Exception)e);
                }
            }
            l.addAll(currentContentToParagraph);
        }
        return l;
    }

    private int getLevel(Tag tag) {
        return Integer.parseInt(Character.toString(tag.getName().charAt(1)));
    }

    @Override
    public boolean isStackOwner() {
        return true;
    }
}

