/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.flow.source.AbstractWekaSetupGenerator;
import java.io.Serializable;
import weka.classifiers.Classifier;
import weka.classifiers.functions.LinearRegression;
import weka.classifiers.meta.FilteredClassifier;
import weka.core.setupgenerator.AbstractParameter;
import weka.core.setupgenerator.ListParameter;
import weka.core.setupgenerator.MathParameter;
import weka.filters.Filter;
import weka.filters.supervised.attribute.PLSFilter;

public class WekaClassifierGenerator
extends AbstractWekaSetupGenerator<Classifier> {
    private static final long serialVersionUID = -6802585691566163552L;

    public String globalInfo() {
        return "Generates multiple classifier setups.";
    }

    @Override
    protected Classifier getDefaultSetup() {
        FilteredClassifier result = new FilteredClassifier();
        result.setFilter((Filter)new PLSFilter());
        result.setClassifier((Classifier)new LinearRegression());
        return result;
    }

    @Override
    protected AbstractParameter[] getDefaultParameters() {
        AbstractParameter[] result = new AbstractParameter[3];
        result[0] = new MathParameter();
        ((MathParameter)result[0]).setProperty("classifier.ridge");
        ((MathParameter)result[0]).setMin(-5.0);
        ((MathParameter)result[0]).setMax(3.0);
        ((MathParameter)result[0]).setStep(1.0);
        ((MathParameter)result[0]).setBase(10.0);
        ((MathParameter)result[0]).setExpression("pow(BASE,I)");
        result[1] = new MathParameter();
        ((MathParameter)result[1]).setProperty("filter.numComponents");
        ((MathParameter)result[1]).setMin(5.0);
        ((MathParameter)result[1]).setMax(20.0);
        ((MathParameter)result[1]).setStep(1.0);
        ((MathParameter)result[1]).setBase(10.0);
        ((MathParameter)result[1]).setExpression("I");
        result[2] = new ListParameter();
        ((ListParameter)result[2]).setProperty("filter.algorithm");
        ((ListParameter)result[2]).setList("PLS1 SIMPLS");
        return result;
    }

    @Override
    protected Class getDefaultSuperClass() {
        return Classifier.class;
    }

    public void setSetup(Classifier value) {
        this.m_Generator.setBaseObject((Serializable)value);
        this.reset();
    }

    public Classifier getSetup() {
        return (Classifier)this.m_Generator.getBaseObject();
    }

    public String setupTipText() {
        return "The base classifier to use for the setups.";
    }
}

