/*
 * Decompiled with CFR 0.152.
 */
package JSci.astro.telescope;

import JSci.astro.telescope.LX200Remote;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.rmi.Naming;

public final class LX200ControlPanel
extends Panel
implements Runnable {
    private LX200Remote lx200;
    private Thread statusThr = null;
    private TextField raField = new TextField(8);
    private TextField decField = new TextField(8);
    private Button gotoButton = new Button("Goto");
    private Button syncButton = new Button("Sync");
    private Label raLabel = new Label();
    private Label decLabel = new Label();
    private Button inButton = new Button("+");
    private Button outButton = new Button("-");
    private Choice focusRateCombo = new Choice();
    private Button northButton = new Button("N");
    private Button eastButton = new Button("E");
    private Button southButton = new Button("S");
    private Button westButton = new Button("W");
    private Choice slewRateCombo = new Choice();

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("Usage: LX200ControlPanel rmi://<host>[:port]/<remote name>");
            return;
        }
        Frame frame = new Frame("LX200 Control Panel");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        frame.add(new LX200ControlPanel(stringArray[0]));
        frame.setSize(100, 400);
        frame.setVisible(true);
    }

    public LX200ControlPanel(String string) {
        try {
            this.lx200 = (LX200Remote)Naming.lookup(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.gotoButton.addActionListener(new GotoActionListener());
        this.syncButton.addActionListener(new SyncActionListener());
        this.inButton.addActionListener(new FocusActionListener(1));
        this.outButton.addActionListener(new FocusActionListener(2));
        this.focusRateCombo.add("Fast");
        this.focusRateCombo.add("Slow");
        this.focusRateCombo.addItemListener(new FocusRateItemListener());
        this.northButton.addActionListener(new SlewActionListener(1));
        this.eastButton.addActionListener(new SlewActionListener(2));
        this.southButton.addActionListener(new SlewActionListener(3));
        this.westButton.addActionListener(new SlewActionListener(4));
        this.slewRateCombo.add("Slew");
        this.slewRateCombo.add("Find");
        this.slewRateCombo.add("Center");
        this.slewRateCombo.add("Guide");
        this.slewRateCombo.addItemListener(new SlewRateItemListener());
        Panel panel = new Panel();
        panel.add(this.raLabel);
        panel.add(this.decLabel);
        panel.add(this.raField);
        panel.add(this.decField);
        panel.add(this.gotoButton);
        panel.add(this.syncButton);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(3, 1));
        panel2.add(this.inButton);
        panel2.add(this.outButton);
        panel2.add(this.focusRateCombo);
        Panel panel3 = new Panel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        panel3.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.northButton, gridBagConstraints);
        panel3.add(this.northButton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.westButton, gridBagConstraints);
        panel3.add(this.westButton);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.eastButton, gridBagConstraints);
        panel3.add(this.eastButton);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.southButton, gridBagConstraints);
        panel3.add(this.southButton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.slewRateCombo, gridBagConstraints);
        panel3.add(this.slewRateCombo);
        this.add(panel);
        this.add(panel2);
        this.add(panel3);
        this.statusThr = new Thread(this);
        this.statusThr.start();
    }

    public void run() {
        while (this.statusThr == Thread.currentThread()) {
            try {
                this.raLabel.setText("RA: " + this.lx200.getRA());
                this.decLabel.setText("Dec: " + this.lx200.getDec());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private class SlewRateItemListener
    implements ItemListener {
        private SlewRateItemListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            try {
                LX200ControlPanel.this.lx200.setSlewRate(LX200ControlPanel.this.slewRateCombo.getSelectedIndex() + 1);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class SlewActionListener
    implements ActionListener {
        private final int direction;
        private boolean slewing = false;

        public SlewActionListener(int n) {
            this.direction = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.slewing) {
                try {
                    LX200ControlPanel.this.lx200.stopSlew(this.direction);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.slewing = false;
            } else {
                try {
                    LX200ControlPanel.this.lx200.startSlew(this.direction);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.slewing = true;
            }
        }
    }

    private class FocusRateItemListener
    implements ItemListener {
        private FocusRateItemListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            try {
                LX200ControlPanel.this.lx200.setFocusRate(LX200ControlPanel.this.focusRateCombo.getSelectedIndex() + 1);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class FocusActionListener
    implements ActionListener {
        private final int direction;
        private boolean focusing = false;

        public FocusActionListener(int n) {
            this.direction = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.focusing) {
                try {
                    LX200ControlPanel.this.lx200.stopFocus();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.focusing = false;
            } else {
                try {
                    LX200ControlPanel.this.lx200.startFocus(this.direction);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.focusing = true;
            }
        }
    }

    private class SyncActionListener
    implements ActionListener {
        private SyncActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                LX200ControlPanel.this.lx200.setObjectCoords(LX200ControlPanel.this.raField.getText(), LX200ControlPanel.this.decField.getText());
                LX200ControlPanel.this.lx200.syncCoords();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class GotoActionListener
    implements ActionListener {
        private GotoActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                LX200ControlPanel.this.lx200.setObjectCoords(LX200ControlPanel.this.raField.getText(), LX200ControlPanel.this.decField.getText());
                LX200ControlPanel.this.lx200.slewToObject();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

