/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.analysis;

import JSci.maths.Complex;
import JSci.maths.analysis.ComplexFunction;

public class ComplexExponential
extends ComplexFunction {
    private final Complex A;
    private final Complex w;

    public ComplexExponential() {
        this.A = Complex.ONE;
        this.w = Complex.ONE;
    }

    public ComplexExponential(Complex complex, Complex complex2) {
        this.A = complex;
        this.w = complex2;
    }

    public Complex map(double d, double d2) {
        double d3 = -(this.w.imag() * d + this.w.real() * d2);
        double d4 = this.w.real() * d - this.w.imag() * d2;
        return this.A.multiply(new Complex(Math.exp(d3) * Math.cos(d4), Math.exp(d3) * Math.sin(d4)));
    }

    public Complex map(Complex complex) {
        return this.map(complex.real(), complex.imag());
    }

    public ComplexFunction differentiate() {
        return new ComplexExponential(this.A.multiply(Complex.I.multiply(this.w)), this.w);
    }

    public ComplexFunction integrate() {
        return new ComplexExponential(this.A.divide(Complex.I.multiply(this.w)), this.w);
    }
}

