/*
 * Decompiled with CFR 0.152.
 */
package JSci.physics.relativity;

import JSci.GlobalSettings;
import JSci.maths.DimensionException;
import JSci.physics.relativity.Rank1Tensor;
import JSci.physics.relativity.Rank3Tensor;
import JSci.physics.relativity.Rank4Tensor;
import JSci.physics.relativity.Tensor;

public class Rank2Tensor
extends Tensor {
    protected double[][] rank2 = new double[4][4];

    public boolean equals(Object object) {
        if (object instanceof Rank2Tensor) {
            Rank2Tensor rank2Tensor = (Rank2Tensor)object;
            for (int i = 0; i < 4; ++i) {
                if (!(Math.abs(this.rank2[i][0] - rank2Tensor.rank2[i][0]) > GlobalSettings.ZERO_TOL || Math.abs(this.rank2[i][1] - rank2Tensor.rank2[i][1]) > GlobalSettings.ZERO_TOL || Math.abs(this.rank2[i][2] - rank2Tensor.rank2[i][2]) > GlobalSettings.ZERO_TOL) && !(Math.abs(this.rank2[i][3] - rank2Tensor.rank2[i][3]) > GlobalSettings.ZERO_TOL)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public double getComponent(int n, int n2) {
        if (n >= 0 && n < 4 && n2 >= 0 && n2 < 4) {
            return this.rank2[n][n2];
        }
        throw new DimensionException("Invalid component.");
    }

    public void setComponent(int n, int n2, double d) {
        if (n < 0 || n >= 4 || n2 < 0 || n2 >= 4) {
            throw new DimensionException("Invalid component.");
        }
        this.rank2[n][n2] = d;
    }

    public Rank2Tensor add(Rank2Tensor rank2Tensor) {
        Rank2Tensor rank2Tensor2 = new Rank2Tensor();
        for (int i = 0; i < 4; ++i) {
            rank2Tensor2.setComponent(i, 0, this.rank2[i][0] + rank2Tensor.rank2[i][0]);
            rank2Tensor2.setComponent(i, 1, this.rank2[i][1] + rank2Tensor.rank2[i][1]);
            rank2Tensor2.setComponent(i, 2, this.rank2[i][2] + rank2Tensor.rank2[i][2]);
            rank2Tensor2.setComponent(i, 3, this.rank2[i][3] + rank2Tensor.rank2[i][3]);
        }
        return rank2Tensor2;
    }

    public Rank2Tensor subtract(Rank2Tensor rank2Tensor) {
        Rank2Tensor rank2Tensor2 = new Rank2Tensor();
        for (int i = 0; i < 4; ++i) {
            rank2Tensor2.setComponent(i, 0, this.rank2[i][0] - rank2Tensor.rank2[i][0]);
            rank2Tensor2.setComponent(i, 1, this.rank2[i][1] - rank2Tensor.rank2[i][1]);
            rank2Tensor2.setComponent(i, 2, this.rank2[i][2] - rank2Tensor.rank2[i][2]);
            rank2Tensor2.setComponent(i, 3, this.rank2[i][3] - rank2Tensor.rank2[i][3]);
        }
        return rank2Tensor2;
    }

    public Rank1Tensor multiply(Rank1Tensor rank1Tensor) {
        Rank1Tensor rank1Tensor2 = new Rank1Tensor();
        rank1Tensor2.setComponent(0, this.rank2[0][0] * rank1Tensor.getComponent(0) + this.rank2[0][1] * rank1Tensor.getComponent(1) + this.rank2[0][2] * rank1Tensor.getComponent(2) + this.rank2[0][3] * rank1Tensor.getComponent(3));
        rank1Tensor2.setComponent(1, this.rank2[1][0] * rank1Tensor.getComponent(0) + this.rank2[1][1] * rank1Tensor.getComponent(1) + this.rank2[1][2] * rank1Tensor.getComponent(2) + this.rank2[1][3] * rank1Tensor.getComponent(3));
        rank1Tensor2.setComponent(2, this.rank2[2][0] * rank1Tensor.getComponent(0) + this.rank2[2][1] * rank1Tensor.getComponent(1) + this.rank2[2][2] * rank1Tensor.getComponent(2) + this.rank2[2][3] * rank1Tensor.getComponent(3));
        rank1Tensor2.setComponent(3, this.rank2[3][0] * rank1Tensor.getComponent(0) + this.rank2[3][1] * rank1Tensor.getComponent(1) + this.rank2[3][2] * rank1Tensor.getComponent(2) + this.rank2[3][3] * rank1Tensor.getComponent(3));
        return rank1Tensor2;
    }

    public Rank3Tensor tensorProduct(Rank1Tensor rank1Tensor) {
        Rank3Tensor rank3Tensor = new Rank3Tensor();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                rank3Tensor.setComponent(i, j, 0, this.rank2[i][j] * rank1Tensor.getComponent(0));
                rank3Tensor.setComponent(i, j, 1, this.rank2[i][j] * rank1Tensor.getComponent(1));
                rank3Tensor.setComponent(i, j, 2, this.rank2[i][j] * rank1Tensor.getComponent(2));
                rank3Tensor.setComponent(i, j, 3, this.rank2[i][j] * rank1Tensor.getComponent(3));
            }
        }
        return rank3Tensor;
    }

    public Rank4Tensor tensorProduct(Rank2Tensor rank2Tensor) {
        Rank4Tensor rank4Tensor = new Rank4Tensor();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    rank4Tensor.setComponent(i, j, k, 0, this.rank2[i][j] * rank2Tensor.rank2[k][0]);
                    rank4Tensor.setComponent(i, j, k, 1, this.rank2[i][j] * rank2Tensor.rank2[k][1]);
                    rank4Tensor.setComponent(i, j, k, 2, this.rank2[i][j] * rank2Tensor.rank2[k][2]);
                    rank4Tensor.setComponent(i, j, k, 3, this.rank2[i][j] * rank2Tensor.rank2[k][3]);
                }
            }
        }
        return rank4Tensor;
    }
}

