/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.analysis;

import JSci.maths.DimensionException;
import JSci.maths.analysis.RealFunction;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;

public abstract class RealFunctionND
implements Ring.Member {
    protected final int dim;

    protected RealFunctionND(int n) {
        this.dim = n;
    }

    public abstract double map(double[] var1);

    public final int dimension() {
        return this.dim;
    }

    public Object getSet() {
        throw new RuntimeException("Not implemented: file bug");
    }

    public AbelianGroup.Member negate() {
        return new Negation(this);
    }

    public AbelianGroup.Member add(AbelianGroup.Member member) {
        if (member instanceof RealFunctionND) {
            return this.add((RealFunctionND)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RealFunctionND add(RealFunctionND realFunctionND) {
        if (this.dim != realFunctionND.dim) {
            throw new DimensionException("Functions have different dimensions.");
        }
        return new Sum(this, realFunctionND);
    }

    public AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof RealFunctionND) {
            return this.subtract((RealFunctionND)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RealFunctionND subtract(RealFunctionND realFunctionND) {
        if (this.dim != realFunctionND.dim) {
            throw new DimensionException("Functions have different dimensions.");
        }
        return new Difference(this, realFunctionND);
    }

    public Ring.Member multiply(Ring.Member member) {
        if (member instanceof RealFunctionND) {
            return this.multiply((RealFunctionND)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RealFunctionND multiply(RealFunctionND realFunctionND) {
        if (this.dim != realFunctionND.dim) {
            throw new DimensionException("Functions have different dimensions.");
        }
        return new Product(this, realFunctionND);
    }

    public Ring.Member inverse() {
        return new Reciprocal(this);
    }

    public Ring.Member divide(Ring.Member member) {
        if (member instanceof RealFunctionND) {
            return this.divide((RealFunctionND)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RealFunctionND divide(RealFunctionND realFunctionND) {
        if (this.dim != realFunctionND.dim) {
            throw new DimensionException("Functions have different dimensions.");
        }
        return new Quotient(this, realFunctionND);
    }

    public RealFunctionND tensor(RealFunction realFunction) {
        return new TensorProductN1D(this, realFunction);
    }

    public RealFunctionND tensor(RealFunctionND realFunctionND) {
        return new TensorProductND(this, realFunctionND);
    }

    public static RealFunctionND constant(int n, double d) {
        return new Constant(n, d);
    }

    private static class Constant
    extends RealFunctionND {
        private final double A;

        public Constant(int n, double d) {
            super(n);
            this.A = d;
        }

        public double map(double[] dArray) {
            return this.A;
        }
    }

    private static class TensorProductND
    extends RealFunctionND {
        private final RealFunctionND f1;
        private final RealFunctionND f2;

        public TensorProductND(RealFunctionND realFunctionND, RealFunctionND realFunctionND2) {
            super(realFunctionND.dim + realFunctionND2.dim);
            this.f1 = realFunctionND;
            this.f2 = realFunctionND2;
        }

        public double map(double[] dArray) {
            double[] dArray2 = new double[this.f1.dim];
            double[] dArray3 = new double[this.f2.dim];
            System.arraycopy(dArray, 0, dArray2, 0, dArray2.length);
            System.arraycopy(dArray, dArray2.length, dArray3, 0, dArray3.length);
            return this.f1.map(dArray2) * this.f2.map(dArray3);
        }
    }

    private static class TensorProductN1D
    extends RealFunctionND {
        private final RealFunctionND f1;
        private final RealFunction f2;

        public TensorProductN1D(RealFunctionND realFunctionND, RealFunction realFunction) {
            super(realFunctionND.dim + 1);
            this.f1 = realFunctionND;
            this.f2 = realFunction;
        }

        public double map(double[] dArray) {
            double[] dArray2 = new double[this.f1.dim];
            System.arraycopy(dArray, 0, dArray2, 0, dArray2.length);
            double d = dArray[dArray2.length];
            return this.f1.map(dArray2) * this.f2.map(d);
        }
    }

    private static class Quotient
    extends RealFunctionND {
        private final RealFunctionND f1;
        private final RealFunctionND f2;

        public Quotient(RealFunctionND realFunctionND, RealFunctionND realFunctionND2) {
            super(realFunctionND.dim);
            this.f1 = realFunctionND;
            this.f2 = realFunctionND2;
        }

        public double map(double[] dArray) {
            return this.f1.map(dArray) / this.f2.map(dArray);
        }
    }

    private static class Reciprocal
    extends RealFunctionND {
        private final RealFunctionND f;

        public Reciprocal(RealFunctionND realFunctionND) {
            super(realFunctionND.dim);
            this.f = realFunctionND;
        }

        public double map(double[] dArray) {
            return 1.0 / this.f.map(dArray);
        }
    }

    private static class Product
    extends RealFunctionND {
        private final RealFunctionND f1;
        private final RealFunctionND f2;

        public Product(RealFunctionND realFunctionND, RealFunctionND realFunctionND2) {
            super(realFunctionND.dim);
            this.f1 = realFunctionND;
            this.f2 = realFunctionND2;
        }

        public double map(double[] dArray) {
            return this.f1.map(dArray) * this.f2.map(dArray);
        }
    }

    private static class Difference
    extends RealFunctionND {
        private final RealFunctionND f1;
        private final RealFunctionND f2;

        public Difference(RealFunctionND realFunctionND, RealFunctionND realFunctionND2) {
            super(realFunctionND.dim);
            this.f1 = realFunctionND;
            this.f2 = realFunctionND2;
        }

        public double map(double[] dArray) {
            return this.f1.map(dArray) - this.f2.map(dArray);
        }
    }

    private static class Sum
    extends RealFunctionND {
        private final RealFunctionND f1;
        private final RealFunctionND f2;

        public Sum(RealFunctionND realFunctionND, RealFunctionND realFunctionND2) {
            super(realFunctionND.dim);
            this.f1 = realFunctionND;
            this.f2 = realFunctionND2;
        }

        public double map(double[] dArray) {
            return this.f1.map(dArray) + this.f2.map(dArray);
        }
    }

    private static class Negation
    extends RealFunctionND {
        private final RealFunctionND f;

        public Negation(RealFunctionND realFunctionND) {
            super(realFunctionND.dim);
            this.f = realFunctionND;
        }

        public double map(double[] dArray) {
            return -this.f.map(dArray);
        }
    }
}

