/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.matrices;

import JSci.maths.algebras.Algebra;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;
import JSci.maths.matrices.AbstractIntegerMatrix;
import JSci.maths.matrices.AbstractIntegerSquareMatrix;
import JSci.maths.matrices.IntegerDiagonalMatrix;
import JSci.maths.matrices.IntegerMatrix;
import java.awt.Dimension;
import java.util.Hashtable;

public final class IntegerMatrixAlgebra
implements Algebra,
Ring {
    private static final Hashtable algebras = new Hashtable();
    private final int rows;
    private final int cols;
    private AbstractIntegerMatrix zero;
    private AbstractIntegerSquareMatrix one;

    static IntegerMatrixAlgebra get(int n, int n2) {
        Dimension dimension = new Dimension(n, n2);
        IntegerMatrixAlgebra integerMatrixAlgebra = (IntegerMatrixAlgebra)algebras.get(dimension);
        if (integerMatrixAlgebra == null) {
            integerMatrixAlgebra = new IntegerMatrixAlgebra(n, n2);
            algebras.put(dimension, integerMatrixAlgebra);
        }
        return integerMatrixAlgebra;
    }

    private IntegerMatrixAlgebra(int n, int n2) {
        this.rows = n;
        this.cols = n2;
    }

    public Ring.Member one() {
        if (this.one == null) {
            this.one = IntegerDiagonalMatrix.identity(this.cols);
        }
        return this.one;
    }

    public boolean isOne(Ring.Member member) {
        return this.one().equals(member);
    }

    public AbelianGroup.Member zero() {
        if (this.zero == null) {
            this.zero = new IntegerMatrix(this.rows, this.cols);
        }
        return this.zero;
    }

    public boolean isZero(AbelianGroup.Member member) {
        return this.zero().equals(member);
    }

    public boolean isNegative(AbelianGroup.Member member, AbelianGroup.Member member2) {
        return this.zero().equals(member.add(member2));
    }
}

