/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.splines;

import JSci.maths.ArrayMath;
import JSci.maths.wavelet.Cascades;
import JSci.maths.wavelet.Filter;
import JSci.maths.wavelet.splines.Spline;
import JSci.maths.wavelet.splines.SumOfDiracs;

public class PiecewiseConstant
extends Spline
implements Filter,
Cloneable {
    protected static final int filtretype = 0;
    private double[] vecteur;
    static final double[] vg = new double[]{1.0, 1.0};

    public String toString() {
        return ArrayMath.toString(this.vecteur);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof PiecewiseConstant && this.vecteur.length == ((PiecewiseConstant)object).dimension()) {
            PiecewiseConstant piecewiseConstant = (PiecewiseConstant)object;
            for (int i = 0; i < this.vecteur.length; ++i) {
                if (this.vecteur[i] == piecewiseConstant.getValue(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int getFilterType() {
        return 0;
    }

    public int previousDimension(int n) {
        int n2 = (int)Math.round((double)n / 2.0);
        if (2 * n2 == n) {
            return n2;
        }
        throw new IllegalArgumentException("Odd number of values into an even Filter.");
    }

    public double[] lowpass(double[] dArray, double[] dArray2) {
        return this.lowpass(dArray);
    }

    public double[] highpass(double[] dArray, double[] dArray2) {
        return this.highpass(dArray);
    }

    public double[] lowpass(double[] dArray) {
        if (dArray.length < 1) {
            throw new IllegalArgumentException("The array is not long enough : " + dArray.length + " < 1");
        }
        double[] dArray2 = new double[2 * dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            int n = 2 * i;
            dArray2[n] = dArray2[n] + dArray[i] * vg[0];
            int n2 = 2 * i + 1;
            dArray2[n2] = dArray2[n2] + dArray[i] * vg[1];
        }
        return dArray2;
    }

    public double[] highpass(double[] dArray) {
        if (dArray.length < 2) {
            throw new IllegalArgumentException("The array is not long enough : " + dArray.length + " < 2");
        }
        double[] dArray2 = Cascades.doublesample(dArray);
        int n = dArray2.length - 1;
        double[] dArray3 = new double[2 * dArray.length];
        double[] dArray4 = new double[]{-1.0, 1.0};
        for (int i = 0; i <= n - 1; ++i) {
            dArray3[i] = ArrayMath.scalarProduct(ArrayMath.extract(i, i + 1, dArray2), dArray4);
        }
        dArray3[n] = ArrayMath.scalarProduct(ArrayMath.extract(n - dArray4.length + 2, n, dArray2), ArrayMath.extract(0, dArray4.length - 2, dArray4));
        return dArray3;
    }

    public PiecewiseConstant(double[] dArray) {
        this.vecteur = dArray;
    }

    public PiecewiseConstant() {
    }

    public Object clone() {
        PiecewiseConstant piecewiseConstant = (PiecewiseConstant)super.clone();
        if (this.vecteur != null) {
            piecewiseConstant.vecteur = ArrayMath.copy(this.vecteur);
        }
        return piecewiseConstant;
    }

    public double getValue(int n) {
        if (n < 0 || n > this.vecteur.length - 1) {
            throw new IllegalArgumentException("Incorrect parameters : " + n + ", " + this.vecteur.length);
        }
        return this.vecteur[n];
    }

    public void setValues(double[] dArray) {
        this.vecteur = dArray;
    }

    public double mass(double d, double d2) {
        double d3 = 0.0;
        for (int i = 0; i < this.vecteur.length; ++i) {
            d3 += this.vecteur[i];
        }
        d3 = d3 * Math.abs(d2 - d) / (double)this.vecteur.length;
        return d3;
    }

    public void setValue(int n, double d) {
        if (n < 0) {
            throw new IllegalArgumentException("The parameter must be positive : " + n + " < 0");
        }
        this.vecteur[n] = d;
    }

    public SumOfDiracs derive() {
        return this.derive(0.0, 1.0);
    }

    public SumOfDiracs derive(double d, double d2) {
        double[] dArray = new double[this.vecteur.length + 1];
        for (int i = 1; i < this.vecteur.length; ++i) {
            dArray[i] = (this.vecteur[i] - this.vecteur[i - 1]) * (double)this.vecteur.length / Math.abs(d2 - d);
        }
        dArray[0] = 0.0;
        dArray[this.vecteur.length] = 0.0;
        SumOfDiracs sumOfDiracs = new SumOfDiracs(dArray);
        return sumOfDiracs;
    }

    public int dimension() {
        return this.vecteur.length + 1;
    }

    public int dimension(int n) {
        return Cascades.dimensionHaar(this.vecteur.length, n);
    }

    public double[] interpolate(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("This parameter must be postive : " + n);
        }
        return Cascades.evaluation(this, n, this.vecteur);
    }

    public double[] evaluate(int n) {
        return this.interpolate(n);
    }
}

