/*
 * Decompiled with CFR 0.152.
 */
package JSci.physics;

import JSci.physics.ClassicalParticle2D;

public class RigidBody2D
extends ClassicalParticle2D {
    protected double angMass;
    protected double ang;
    protected double angVel;

    public void setMomentOfInertia(double d) {
        this.angMass = d;
    }

    public double getMomentOfInertia() {
        return this.angMass;
    }

    public void setAngle(double d) {
        this.ang = d;
    }

    public double getAngle() {
        return this.ang;
    }

    public void setAngularVelocity(double d) {
        this.angVel = d;
    }

    public double getAngularVelocity() {
        return this.angVel;
    }

    public void setAngularMomentum(double d) {
        this.angVel = d / this.angMass;
    }

    public double getAngularMomentum() {
        return this.angMass * this.angVel;
    }

    public double energy() {
        return (this.mass * (this.vx * this.vx + this.vy * this.vy) + this.angMass * this.angVel * this.angVel) / 2.0;
    }

    public ClassicalParticle2D move(double d) {
        return this.rotate(d).translate(d);
    }

    public RigidBody2D rotate(double d) {
        this.ang += this.angVel * d;
        if (this.ang > Math.PI * 2) {
            this.ang -= Math.PI * 2;
        } else if (this.ang < 0.0) {
            this.ang += Math.PI * 2;
        }
        return this;
    }

    public RigidBody2D angularAccelerate(double d, double d2) {
        this.angVel += d * d2;
        return this;
    }

    public RigidBody2D applyTorque(double d, double d2) {
        return this.angularAccelerate(d / this.angMass, d2);
    }

    public RigidBody2D applyForce(double d, double d2, double d3, double d4, double d5) {
        this.applyTorque(d3 * d2 - d4 * d, d5);
        double d6 = (d3 * d + d4 * d2) / (d3 * d3 + d4 * d4);
        this.applyForce(d6 * d3, d6 * d4, d5);
        return this;
    }

    public RigidBody2D collide(RigidBody2D rigidBody2D, double d, double d2) {
        double d3 = this.mass + rigidBody2D.mass;
        double d4 = rigidBody2D.vx - this.vx;
        double d5 = rigidBody2D.vy - this.vy;
        double d6 = Math.cos(d);
        double d7 = Math.sin(d);
        this.vx += rigidBody2D.mass * (d2 * (d4 * d6 + d5 * d7) + d4) / d3;
        this.vy += rigidBody2D.mass * (d2 * (d5 * d6 - d4 * d7) + d5) / d3;
        rigidBody2D.vx -= this.mass * (d2 * (d4 * d6 + d5 * d7) + d4) / d3;
        rigidBody2D.vy -= this.mass * (d2 * (d5 * d6 - d4 * d7) + d5) / d3;
        return this;
    }

    public RigidBody2D angularCollide(RigidBody2D rigidBody2D, double d) {
        double d2 = (this.angMass + rigidBody2D.angMass) / (d + 1.0);
        double d3 = rigidBody2D.angVel - this.angVel;
        this.angVel += rigidBody2D.angMass * d3 / d2;
        rigidBody2D.angVel -= this.angMass * d3 / d2;
        return this;
    }
}

