/*
 * Decompiled with CFR 0.152.
 */
package adams.data.statistics;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;

public class Percentile<E extends Comparable>
implements Serializable {
    private static final long serialVersionUID = 3693932591687404328L;
    protected Vector<E> m_Values = new Vector();
    protected boolean m_Sorted = false;
    protected Comparator m_Comparator;

    public Percentile() {
        this(null);
    }

    public Percentile(Comparator comparator) {
        this.m_Comparator = comparator;
    }

    public void add(E value) {
        this.m_Values.add(value);
        this.m_Sorted = false;
    }

    public void addAll(Collection<E> values) {
        this.m_Values.addAll(values);
        this.m_Sorted = false;
    }

    public void addAll(E[] values) {
        for (E value : values) {
            this.m_Values.add(value);
        }
        this.m_Sorted = false;
    }

    public Vector<E> getValues() {
        return this.m_Values;
    }

    protected void sort() {
        if (this.m_Sorted) {
            return;
        }
        if (this.m_Comparator == null) {
            Collections.sort(this.m_Values);
        } else {
            Collections.sort(this.m_Values, this.m_Comparator);
        }
        this.m_Sorted = true;
    }

    public E getPercentile(double percentage) {
        Comparable result = null;
        this.sort();
        if (this.size() > 0) {
            int index = (int)Math.round((double)this.m_Values.size() * percentage) - 1;
            if (index < 0) {
                index = 0;
            }
            result = (Comparable)this.m_Values.get(index);
        }
        return (E)result;
    }

    public void clear() {
        this.m_Values.clear();
        this.m_Sorted = false;
    }

    public int size() {
        return this.m_Values.size();
    }

    public String toString() {
        return this.m_Values.toString();
    }
}

