/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.core.io.PlaceholderFile;
import adams.flow.condition.bool.AbstractBooleanCondition;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.core.Unknown;

public class FileExists
extends AbstractBooleanCondition {
    private static final long serialVersionUID = -6986050060604039765L;
    protected PlaceholderFile m_File;

    @Override
    public String globalInfo() {
        return "Evaluates to 'true' if the file exists.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("file", "file", new PlaceholderFile("."));
    }

    public void setFile(PlaceholderFile value) {
        this.m_File = value;
        this.reset();
    }

    public PlaceholderFile getFile() {
        return this.m_File;
    }

    public String fileTipText() {
        return "The file to look for.";
    }

    @Override
    public String getQuickInfo() {
        String result = "file: ";
        String variable = this.getOptionManager().getVariableForProperty("file");
        result = variable != null ? result + variable : result + this.m_File.toString();
        return result;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public String setUp() {
        String result = null;
        if (this.m_File == null) {
            result = "No file provided!";
        }
        return result;
    }

    @Override
    protected boolean doEvaluate(AbstractActor owner, Token token) {
        return this.m_File.exists() && !this.m_File.isDirectory();
    }
}

