/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.test;

import adams.core.io.PlaceholderFile;
import adams.flow.condition.test.AbstractCondition;

public class FileExists
extends AbstractCondition {
    private static final long serialVersionUID = 3690024487474608636L;
    protected PlaceholderFile m_File;
    protected boolean m_Invert;

    @Override
    public String globalInfo() {
        return "Checks whether a specified file exists.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("file", "file", new PlaceholderFile("."));
        this.m_OptionManager.add("invert", "invert", false);
    }

    public void setFile(PlaceholderFile value) {
        this.m_File = value;
    }

    public PlaceholderFile getFile() {
        return this.m_File;
    }

    public String fileTipText() {
        return "The file to look for.";
    }

    public void setInvert(boolean value) {
        this.m_Invert = value;
        this.reset();
    }

    public boolean getInvert() {
        return this.m_Invert;
    }

    public String invertTipText() {
        return "If set to true, then the matching sense is inverted.";
    }

    @Override
    protected String performTest() {
        if (this.m_File.isDirectory()) {
            return "Target '" + this.m_File + "' is a directory!";
        }
        if (this.m_File.exists() && this.m_Invert) {
            return "File '" + this.m_File + "' already exists!";
        }
        if (!this.m_File.exists() && !this.m_Invert) {
            return "File '" + this.m_File + "' does not exist!";
        }
        return null;
    }
}

