/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.Utils;
import adams.core.base.BaseDateTime;
import adams.core.base.BaseRegExp;
import adams.core.io.DirectoryLister;
import adams.core.io.PlaceholderDirectory;
import adams.flow.source.AbstractArrayProvider;
import java.util.Arrays;
import java.util.Vector;

public class DirectoryLister
extends AbstractArrayProvider {
    private static final long serialVersionUID = -5015637337437403790L;
    protected adams.core.io.DirectoryLister m_Lister;
    protected int m_Wait;
    protected boolean m_AlwaysWait;
    protected boolean m_PauseRequired;

    @Override
    public String globalInfo() {
        return "Returns the contents of a directory (files/dirs).";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("dir", "watchDir", new PlaceholderDirectory("."));
        this.m_OptionManager.add("list-dirs", "listDirs", false);
        this.m_OptionManager.add("list-files", "listFiles", false);
        this.m_OptionManager.add("max-items", "maxItems", -1);
        this.m_OptionManager.add("regexp", "regExp", new BaseRegExp(""));
        this.m_OptionManager.add("sorting", "sorting", (Object)DirectoryLister.Sorting.NO_SORTING);
        this.m_OptionManager.add("descending", "sortDescending", false);
        this.m_OptionManager.add("recursive", "recursive", false);
        this.m_OptionManager.add("max-depth", "maxDepth", -1);
        this.m_OptionManager.add("stop-file", "stopFile", "STOP.txt");
        this.m_OptionManager.add("wait", "wait", -1);
        this.m_OptionManager.add("always-wait", "alwaysWait", false);
        this.m_OptionManager.add("skip-locked", "skipLockedFiles", false);
        this.m_OptionManager.add("min-timestamp", "minFileTimestamp", new BaseDateTime("-INF"));
        this.m_OptionManager.add("max-timestamp", "maxFileTimestamp", new BaseDateTime("+INF"));
    }

    @Override
    public String getQuickInfo() {
        String result = "";
        if (this.getListFiles()) {
            result = result + "files";
        }
        if (this.getListDirs()) {
            if (result.length() > 0) {
                result = result + "/";
            }
            result = result + "dirs";
        }
        if (result.length() == 0) {
            result = "nothing";
        }
        result = result + " from ";
        String variable = this.getOptionManager().getVariableForProperty("watchDir");
        result = variable != null ? result + variable : result + this.getWatchDir().toString();
        Vector<String> options = new Vector<String>();
        options.add(this.getSorting().toString());
        if (this.getSorting() != DirectoryLister.Sorting.NO_SORTING && this.getSortDescending()) {
            options.add("descending");
        }
        if (this.getRecursive()) {
            options.add("recursive");
        }
        if (this.getMaxItems() > 0) {
            options.add("max=" + this.getMaxItems());
        }
        if (this.getWait() > 0) {
            options.add("polling=" + this.getWait());
        }
        if (this.getOutputArray()) {
            options.add("array");
        }
        if (options.size() > 0) {
            result = result + " [" + Utils.flatten(options, ", ") + "]";
        }
        return result;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Lister = new adams.core.io.DirectoryLister();
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_PauseRequired = false;
    }

    public void setWatchDir(PlaceholderDirectory value) {
        this.m_Lister.setWatchDir(value);
    }

    public PlaceholderDirectory getWatchDir() {
        return this.m_Lister.getWatchDir();
    }

    public String watchDirTipText() {
        return "The directory to watch for files/directories.";
    }

    public void setMaxItems(int value) {
        this.m_Lister.setMaxItems(value);
        this.reset();
    }

    public int getMaxItems() {
        return this.m_Lister.getMaxItems();
    }

    public String maxItemsTipText() {
        return "The maximum number of items (files/dirs) to return (<= 0 is unlimited).";
    }

    @Override
    public String outputArrayTipText() {
        return "Whether to output the files as array or as single strings.";
    }

    public void setRegExp(BaseRegExp value) {
        this.m_Lister.setRegExp(value);
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_Lister.getRegExp();
    }

    public String regExpTipText() {
        return "The regular expression that the files/dirs must match (empty string matches all).";
    }

    public void setStopFile(String value) {
        this.m_Lister.setStopFile(value);
        this.reset();
    }

    public String getStopFile() {
        return this.m_Lister.getStopFile();
    }

    public String stopFileTipText() {
        return "The name of the file, that finishes the watching.";
    }

    public void setListDirs(boolean value) {
        this.m_Lister.setListDirs(value);
        this.reset();
    }

    public boolean getListDirs() {
        return this.m_Lister.getListDirs();
    }

    public String listDirsTipText() {
        return "Whether to include directories in the output.";
    }

    public void setListFiles(boolean value) {
        this.m_Lister.setListFiles(value);
        this.reset();
    }

    public boolean getListFiles() {
        return this.m_Lister.getListFiles();
    }

    public String listFilesTipText() {
        return "Whether to include files in the output.";
    }

    public void setSorting(DirectoryLister.Sorting value) {
        this.m_Lister.setSorting(value);
        this.reset();
    }

    public DirectoryLister.Sorting getSorting() {
        return this.m_Lister.getSorting();
    }

    public String sortingTipText() {
        return "The type of sorting to perform.";
    }

    public void setSortDescending(boolean value) {
        this.m_Lister.setSortDescending(value);
        this.reset();
    }

    public boolean getSortDescending() {
        return this.m_Lister.getSortDescending();
    }

    public String sortDescendingTipText() {
        return "If set to true, the files are sorted in descending manner.";
    }

    public void setWait(int value) {
        if (value > 0 || value == -1) {
            this.m_Wait = value;
        } else {
            this.getSystemErr().println("Number of seconds to wait must be larger than 0 or -1 (provided: " + value + ")!");
        }
    }

    public int getWait() {
        return this.m_Wait;
    }

    public String waitTipText() {
        return "The number of seconds to wait before polling the directory again if no elements were retrieved; a value of -1 indicates that polling happens only once.";
    }

    public void setAlwaysWait(boolean value) {
        this.m_AlwaysWait = value;
        this.reset();
    }

    public boolean getAlwaysWait() {
        return this.m_AlwaysWait;
    }

    public String alwaysWaitTipText() {
        return "If set to true, then the waiting period is enforced between polls, even if there are files/dirs that could get processed.";
    }

    public void setRecursive(boolean value) {
        this.m_Lister.setRecursive(value);
        this.reset();
    }

    public boolean getRecursive() {
        return this.m_Lister.getRecursive();
    }

    public String recursiveTipText() {
        return "Whether to search recursively or not.";
    }

    public void setMaxDepth(int value) {
        this.m_Lister.setMaxDepth(value);
        this.reset();
    }

    public int getMaxDepth() {
        return this.m_Lister.getMaxDepth();
    }

    public String maxDepthTipText() {
        return "The maximum depth to search in recursive mode (1 = only watch directory, -1 = infinite).";
    }

    public void setSkipLockedFiles(boolean value) {
        this.m_Lister.setSkipLockedFiles(value);
        this.reset();
    }

    public boolean getSkipLockedFiles() {
        return this.m_Lister.getSkipLockedFiles();
    }

    public String skipLockedFilesTipText() {
        return "If set to true, locked files are skipped. Depends on the underlying OS how this is implemented. Under Linux, a JVM would have to lock the file explicitly via java.nio.channels.FileChannel.lock(). Simply opening it for writing does not lock the file.";
    }

    public void setMinFileTimestamp(BaseDateTime value) {
        this.m_Lister.setMinFileTimestamp(value);
        this.reset();
    }

    public BaseDateTime getMinFileTimestamp() {
        return this.m_Lister.getMinFileTimestamp();
    }

    public String minFileTimestampTipText() {
        return "The minimum file timestamp that the files can have.";
    }

    public void setMaxFileTimestamp(BaseDateTime value) {
        this.m_Lister.setMaxFileTimestamp(value);
        this.reset();
    }

    public BaseDateTime getMaxFileTimestamp() {
        return this.m_Lister.getMaxFileTimestamp();
    }

    public String maxFileTimestampTipText() {
        return "The maximum file timestamp that the files can have.";
    }

    @Override
    protected Class getItemClass() {
        return String.class;
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null && !this.getListFiles() && !this.getListDirs()) {
            result = "Neither files nor directories are being listed - choose at least one option!";
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doExecute() {
        String result = null;
        if (this.m_PauseRequired) {
            for (int i = 0; i < this.m_Wait * 10; ++i) {
                try {
                    DirectoryLister directoryLister = this;
                    synchronized (directoryLister) {
                        this.wait(100L);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (this.isStopped()) break;
            }
        }
        try {
            this.m_Queue.addAll(Arrays.asList(this.m_Lister.list()));
        }
        catch (Exception e) {
            this.getSystemErr().printStackTrace(e);
            result = e.toString();
        }
        this.m_PauseRequired = this.m_AlwaysWait && this.m_Wait != -1 || this.m_Queue.size() == 0 && !this.m_Lister.hasStopFileEncountered() && this.m_Wait != -1;
        return result;
    }

    @Override
    public boolean isFinished() {
        return this.m_Lister.hasStopFileEncountered() || this.m_Wait == -1;
    }

    @Override
    public void stopExecution() {
        if (this.m_Lister != null) {
            this.m_Lister.stop();
        }
        super.stopExecution();
    }
}

