/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.flow.core.Token;
import adams.flow.source.AbstractInteractiveSource;
import adams.gui.core.GUIHelper;
import javax.swing.JOptionPane;

public class PasteFromClipboard
extends AbstractInteractiveSource {
    private static final long serialVersionUID = 8200691218381875131L;
    protected String m_Message;
    protected Token m_OutputToken;

    @Override
    public String globalInfo() {
        return "Pops up a dialog, prompting the user to accept content from clipboard.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("message", "message", "Click 'OK' to obtain text from clipboard");
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("message");
        String result = variable != null ? variable : this.m_Message;
        return result;
    }

    public void setMessage(String value) {
        this.m_Message = value;
        this.reset();
    }

    public String getMessage() {
        return this.m_Message;
    }

    public String messageTipText() {
        return "The message to prompt the user with.";
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_OutputToken = null;
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class};
    }

    @Override
    public boolean doInteract() {
        int retVal = JOptionPane.showConfirmDialog(null, this.m_Message, this.getName(), 2);
        if (retVal == 0 && GUIHelper.canPasteFromClipboard()) {
            this.m_OutputToken = new Token(GUIHelper.pasteFromClipboard());
        }
        return retVal == 0;
    }

    @Override
    public Token output() {
        Token result = this.m_OutputToken;
        this.m_OutputToken = null;
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_OutputToken != null;
    }
}

