/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.template;

import adams.core.option.VariableLister;
import adams.flow.control.AbstractTee;
import adams.flow.control.Once;
import adams.flow.control.Trigger;
import adams.flow.core.AbstractActor;
import adams.flow.core.MutableActorHandler;
import adams.flow.sink.Display;
import adams.flow.sink.HistoryDisplay;
import adams.flow.source.OptionTraverser;
import adams.flow.template.AbstractActorTemplate;

public class OptionTraverser
extends AbstractActorTemplate {
    private static final long serialVersionUID = 7111338348242418621L;
    protected adams.core.option.OptionTraverser m_Traverser;
    protected OptionTraverser.TraversalStart m_Start;
    protected boolean m_Once;

    @Override
    public String globalInfo() {
        return "Generates a sub-flow that displays the result of the specified option traversal algorithm, e.g., for displaying currently attached variables.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("traverser", "traverser", new VariableLister());
        this.m_OptionManager.add("start", "start", (Object)OptionTraverser.TraversalStart.ROOT);
        this.m_OptionManager.add("once", "once", false);
    }

    public void setTraverser(adams.core.option.OptionTraverser value) {
        this.m_Traverser = value;
        this.reset();
    }

    public adams.core.option.OptionTraverser getTraverser() {
        return this.m_Traverser;
    }

    public String traverserTipText() {
        return "The traverser to use.";
    }

    public void setStart(OptionTraverser.TraversalStart value) {
        this.m_Start = value;
        this.reset();
    }

    public OptionTraverser.TraversalStart getStart() {
        return this.m_Start;
    }

    public String startTipText() {
        return "Defines where to start the traversal from.";
    }

    public void setOnce(boolean value) {
        this.m_Once = value;
        this.reset();
    }

    public boolean getOnce() {
        return this.m_Once;
    }

    public String onceTipText() {
        return "If enabled, the option traversal gets executed only once.";
    }

    protected void addDisplay(MutableActorHandler handler) {
        if (this.m_Once) {
            handler.add(handler.size(), new Display());
        } else {
            handler.add(handler.size(), new HistoryDisplay());
        }
    }

    @Override
    protected AbstractActor doGenerate() {
        AbstractTee result;
        Trigger trigger = new Trigger();
        adams.flow.source.OptionTraverser traverser = new adams.flow.source.OptionTraverser();
        traverser.setTraverser(this.m_Traverser);
        traverser.setStart(this.m_Start);
        trigger.add(trigger.size(), traverser);
        this.addDisplay(trigger);
        if (this.m_Once) {
            Once once = new Once();
            once.add(once.size(), trigger);
            result = once;
        } else {
            result = trigger;
        }
        return result;
    }
}

