/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.ClassLocator;
import adams.gui.core.ComparableTableModel;
import adams.gui.core.CustomSearchTableModel;
import adams.gui.core.MouseUtils;
import adams.gui.core.SearchParameters;
import adams.gui.core.SearchableTableModel;
import adams.gui.core.SortableTableModel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class SortableAndSearchableWrapperTableModel
extends AbstractTableModel
implements TableModelListener,
SortableTableModel,
SearchableTableModel,
CustomSearchTableModel {
    private static final long serialVersionUID = 1379439060928152100L;
    protected TableModel m_Model;
    protected int[] m_SortedIndices = null;
    protected int m_SortColumn;
    protected boolean m_SortAscending;
    protected MouseListener m_MouseListener = null;
    protected boolean m_IsComparableTableModel;
    protected String m_SearchString;
    protected boolean m_RegExpSearch;
    protected Vector<Integer> m_DisplayIndices = null;
    protected boolean[] m_ColumnIsNumeric = null;

    public SortableAndSearchableWrapperTableModel() {
        this(null);
    }

    public SortableAndSearchableWrapperTableModel(TableModel model) {
        this.setUnsortedModel(model);
    }

    @Override
    public void setUnsortedModel(TableModel value) {
        this.setUnsortedModel(value, false);
    }

    public void setUnsortedModel(TableModel value, boolean restoreSorting) {
        boolean sorted = this.isSorted();
        int sortCol = this.getSortColumn();
        boolean asc = this.isAscending();
        this.m_Model = value;
        this.m_IsComparableTableModel = this.m_Model instanceof ComparableTableModel;
        this.initialize();
        if (restoreSorting && sorted) {
            this.sort(sortCol, asc);
        }
        this.fireTableDataChanged();
    }

    @Override
    public TableModel getUnsortedModel() {
        return this.m_Model;
    }

    protected void initialize() {
        if (this.getUnsortedModel() == null) {
            this.m_SortedIndices = null;
            this.m_DisplayIndices = null;
            this.m_ColumnIsNumeric = null;
        } else {
            this.initializeSortIndices();
            this.initializeColumnTypes();
            this.m_DisplayIndices = null;
            this.m_SortColumn = -1;
            this.m_SortAscending = true;
            this.getUnsortedModel().addTableModelListener(this);
            if (this.m_SearchString != null) {
                this.search(this.m_SearchString, this.m_RegExpSearch);
            }
        }
    }

    protected void initializeColumnTypes() {
        this.m_ColumnIsNumeric = new boolean[this.getColumnCount()];
        for (int i = 0; i < this.m_ColumnIsNumeric.length; ++i) {
            Class cls = this.getColumnClass(i);
            if (cls != Byte.class && cls != Short.class && cls != Integer.class && cls != Long.class && cls != Float.class && cls != Double.class) continue;
            this.m_ColumnIsNumeric[i] = true;
        }
    }

    protected boolean isColumnNumeric(int colIndex) {
        if (this.m_ColumnIsNumeric == null) {
            return false;
        }
        return this.m_ColumnIsNumeric[colIndex];
    }

    protected void initializeSortIndices() {
        this.m_SortedIndices = new int[this.getUnsortedModel().getRowCount()];
        for (int i = 0; i < this.m_SortedIndices.length; ++i) {
            this.m_SortedIndices[i] = i;
        }
    }

    @Override
    public boolean isSorted() {
        return this.m_SortColumn > -1;
    }

    @Override
    public int getSortColumn() {
        return this.m_SortColumn;
    }

    @Override
    public boolean isAscending() {
        return this.m_SortAscending;
    }

    protected boolean isInitialized() {
        return this.getUnsortedModel() != null;
    }

    @Override
    public int getActualRow(int visibleRow) {
        int result = -1;
        if (this.isInitialized()) {
            result = this.m_DisplayIndices != null ? this.m_SortedIndices[this.m_DisplayIndices.get(visibleRow)] : this.m_SortedIndices[visibleRow];
        }
        return result;
    }

    @Override
    public int getDisplayRow(int internalRow) {
        int result = -1;
        if (this.isInitialized()) {
            int i;
            int sorted = -1;
            for (i = 0; i < this.m_SortedIndices.length; ++i) {
                if (this.m_SortedIndices[i] != internalRow) continue;
                sorted = i;
                break;
            }
            if (this.m_DisplayIndices != null) {
                for (i = 0; i < this.m_DisplayIndices.size(); ++i) {
                    if (this.m_DisplayIndices.get(i) != sorted) continue;
                    result = i;
                    break;
                }
            } else {
                result = sorted;
            }
        }
        return result;
    }

    public Class getColumnClass(int columnIndex) {
        if (!this.isInitialized()) {
            return null;
        }
        return this.getUnsortedModel().getColumnClass(columnIndex);
    }

    @Override
    public int getColumnCount() {
        if (!this.isInitialized()) {
            return 0;
        }
        return this.getUnsortedModel().getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (!this.isInitialized()) {
            return null;
        }
        return this.getUnsortedModel().getColumnName(columnIndex);
    }

    @Override
    public int getRowCount() {
        int result = 0;
        if (this.isInitialized()) {
            result = this.m_DisplayIndices == null ? this.getUnsortedModel().getRowCount() : this.m_DisplayIndices.size();
        }
        return result;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (!this.isInitialized()) {
            return null;
        }
        return this.getUnsortedModel().getValueAt(this.getActualRow(rowIndex), columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (!this.isInitialized()) {
            return false;
        }
        return this.getUnsortedModel().isCellEditable(this.getActualRow(rowIndex), columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this.isInitialized()) {
            this.getUnsortedModel().setValueAt(aValue, this.getActualRow(rowIndex), columnIndex);
        }
    }

    protected Class getColumnClassForComparison(int columnIndex) {
        if (this.m_IsComparableTableModel) {
            return ((ComparableTableModel)this.getUnsortedModel()).getComparisonColumnClass(columnIndex);
        }
        return this.getUnsortedModel().getColumnClass(columnIndex);
    }

    @Override
    public void sort(int columnIndex) {
        this.sort(columnIndex, true);
    }

    @Override
    public void sort(int columnIndex, boolean ascending) {
        int i;
        if (!this.isInitialized() || this.getUnsortedModel().getRowCount() != this.m_SortedIndices.length) {
            System.out.println(this.getClass().getName() + ": Table model not initialized!");
            return;
        }
        this.m_DisplayIndices = null;
        this.m_SortColumn = columnIndex;
        this.m_SortAscending = ascending;
        this.initializeSortIndices();
        if (this.m_SortColumn == -1) {
            return;
        }
        boolean columnType = ClassLocator.hasInterface(Comparable.class, this.getColumnClassForComparison(this.m_SortColumn));
        ArrayList<SortContainer> sorted = new ArrayList<SortContainer>();
        for (i = 0; i < this.getRowCount(); ++i) {
            Object value = this.getValueForComparison(this.m_SortedIndices[i], this.m_SortColumn);
            SortContainer cont = !columnType ? new SortContainer((Comparable)((Object)(value == null ? null : value.toString())), this.m_SortedIndices[i]) : new SortContainer((Comparable)value, this.m_SortedIndices[i]);
            sorted.add(cont);
        }
        Collections.sort(sorted);
        for (i = 0; i < sorted.size(); ++i) {
            this.m_SortedIndices[i] = this.m_SortAscending ? ((SortContainer)sorted.get(i)).getIndex() : ((SortContainer)sorted.get(sorted.size() - 1 - i)).getIndex();
        }
        sorted.clear();
        sorted = null;
        if (this.m_SearchString != null) {
            this.search(this.m_SearchString, this.m_RegExpSearch);
        }
    }

    protected Object getValueForComparison(int row, int column) {
        if (this.m_IsComparableTableModel) {
            return ((ComparableTableModel)this.getUnsortedModel()).getComparisonValueAt(row, column);
        }
        return this.getUnsortedModel().getValueAt(row, column);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.initializeSortIndices();
        if (this.isSorted()) {
            this.sort(this.m_SortColumn, this.m_SortAscending);
        }
        this.fireTableChanged(e);
    }

    public void addMouseListenerToHeader(JTable table) {
        final SortableAndSearchableWrapperTableModel fModel = this;
        final JTable fTable = table;
        fTable.setColumnSelectionAllowed(false);
        JTableHeader header = fTable.getTableHeader();
        if (header != null) {
            if (this.m_MouseListener == null) {
                this.m_MouseListener = new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        TableColumnModel columnModel = fTable.getColumnModel();
                        int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                        int column = fTable.convertColumnIndexToModel(viewColumn);
                        if (MouseUtils.isLeftClick(e) && !e.isAltDown() && !e.isControlDown() && column != -1) {
                            fModel.sort(column, !e.isShiftDown());
                        }
                    }
                };
            }
            header.addMouseListener(this.m_MouseListener);
        }
    }

    public MouseListener getHeaderMouseListener() {
        return this.m_MouseListener;
    }

    @Override
    public int getActualRowCount() {
        return this.getUnsortedModel().getRowCount();
    }

    @Override
    public boolean isSearchMatch(SearchParameters params, int row) {
        Object value;
        boolean result = false;
        for (int i = 0; i < this.getColumnCount() && (this.isColumnNumeric(i) || (value = this.getUnsortedModel().getValueAt(row, i)) == null || !(result = params.matches(value.toString()))); ++i) {
        }
        return result;
    }

    @Override
    public synchronized void search(String searchString, boolean regexp) {
        boolean customSearch = this.getUnsortedModel() instanceof CustomSearchTableModel;
        this.m_RegExpSearch = regexp;
        this.m_SearchString = searchString;
        SearchParameters params = new SearchParameters(this.m_SearchString, this.m_RegExpSearch);
        if (this.m_SearchString == null) {
            this.m_DisplayIndices = null;
        } else {
            this.m_DisplayIndices = new Vector();
            for (int i = 0; i < this.getActualRowCount(); ++i) {
                if (customSearch) {
                    if (!((CustomSearchTableModel)this.getUnsortedModel()).isSearchMatch(params, this.m_SortedIndices[i])) continue;
                    this.m_DisplayIndices.add(i);
                    continue;
                }
                if (!this.isSearchMatch(params, this.m_SortedIndices[i])) continue;
                this.m_DisplayIndices.add(i);
            }
        }
        this.fireTableDataChanged();
    }

    @Override
    public String getSeachString() {
        return this.m_SearchString;
    }

    @Override
    public boolean isRegExpSearch() {
        return this.m_RegExpSearch;
    }

    public static class SortContainer
    implements Comparable<SortContainer> {
        protected Comparable m_Value;
        protected int m_Index;

        public SortContainer(Comparable value, int index) {
            this.m_Value = value;
            this.m_Index = index;
        }

        public Comparable getValue() {
            return this.m_Value;
        }

        public int getIndex() {
            return this.m_Index;
        }

        @Override
        public int compareTo(SortContainer o) {
            if (this.m_Value == null || o.getValue() == null) {
                if (this.m_Value == o.getValue()) {
                    return 0;
                }
                if (this.m_Value == null) {
                    return -1;
                }
                return 1;
            }
            if (this.m_Value.getClass().equals(o.getValue().getClass())) {
                return this.m_Value.compareTo(o.getValue());
            }
            return this.m_Value.toString().compareTo(o.getValue().toString());
        }

        public boolean equals(Object obj) {
            return this.compareTo((SortContainer)obj) == 0;
        }

        public String toString() {
            return "value=" + this.m_Value + ", index=" + this.m_Index;
        }
    }
}

