/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.option.AbstractOptionProducer;
import adams.core.option.NestedProducer;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.gui.core.BaseDialog;
import adams.gui.core.GUIHelper;
import adams.gui.core.TextEditorPanel;
import adams.gui.goe.AbstractGenericObjectEditorHandler;
import adams.gui.goe.CustomStringRepresentationHandler;
import adams.gui.goe.GenericArrayEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import java.lang.reflect.Array;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GenericObjectEditorPopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = -5216584001020734521L;
    protected HashSet<ChangeListener> m_ChangeListeners = new HashSet();

    public GenericObjectEditorPopupMenu(final PropertyEditor editor, final JComponent comp) {
        JMenuItem item = null;
        boolean hasNested = editor.getValue() instanceof OptionHandler;
        final boolean customStringRepresentation = editor instanceof GenericArrayEditor ? ((GenericArrayEditor)editor).getElementEditor() instanceof CustomStringRepresentationHandler : editor instanceof CustomStringRepresentationHandler;
        final String itemText = this.getMenuItemText(customStringRepresentation);
        boolean canChangeClass = this.getCanChangeClassInDialog(editor);
        if (editor instanceof GenericArrayEditor) {
            canChangeClass = this.getCanChangeClassInDialog(((GenericArrayEditor)editor).getElementEditor());
        }
        if (hasNested) {
            item = new JMenuItem("Copy nested setup", GUIHelper.getIcon("copy.gif"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GUIHelper.copyToClipboard(AbstractOptionProducer.toString(NestedProducer.class, (OptionHandler)editor.getValue()));
                }
            });
            this.add(item);
        }
        item = customStringRepresentation ? new JMenuItem("Copy " + itemText, GUIHelper.getEmptyIcon()) : new JMenuItem("Copy command-line setup", GUIHelper.getEmptyIcon());
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringBuilder content = new StringBuilder();
                Object current = editor.getValue();
                boolean isArray = current.getClass().isArray();
                PropertyEditor actualEditor = editor;
                if (isArray) {
                    actualEditor = ((GenericArrayEditor)editor).getElementEditor();
                }
                if (isArray) {
                    for (int i = 0; i < Array.getLength(current); ++i) {
                        if (i > 0) {
                            content.append("\n");
                        }
                        if (customStringRepresentation) {
                            content.append(((CustomStringRepresentationHandler)((Object)actualEditor)).toCustomStringRepresentation(Array.get(current, i)));
                            continue;
                        }
                        content.append(OptionUtils.getCommandLine(Array.get(current, i)));
                    }
                } else if (customStringRepresentation) {
                    content.append(((CustomStringRepresentationHandler)((Object)actualEditor)).toCustomStringRepresentation(current));
                } else {
                    content.append(OptionUtils.getCommandLine(current));
                }
                if (content.length() > 0) {
                    GUIHelper.copyToClipboard(content.toString());
                }
            }
        });
        this.add(item);
        if (canChangeClass || customStringRepresentation) {
            item = new JMenuItem("Paste " + itemText, GUIHelper.getIcon("paste.gif"));
            item.setEnabled(GUIHelper.canPasteFromClipboard());
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GenericObjectEditorPopupMenu.this.updateEditor(editor, comp, customStringRepresentation, GUIHelper.pasteSetupFromClipboard());
                }
            });
            this.add(item);
            item = new JMenuItem("Enter " + itemText + "...", GUIHelper.getIcon("input.png"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    final BaseDialog dlg = GUIHelper.getParentDialog(comp) != null ? new BaseDialog(GUIHelper.getParentDialog(comp), Dialog.ModalityType.DOCUMENT_MODAL) : new BaseDialog(GUIHelper.getParentFrame(comp), true);
                    dlg.setTitle("Enter " + itemText);
                    dlg.getContentPane().setLayout(new BorderLayout());
                    final TextEditorPanel textpanel = new TextEditorPanel();
                    dlg.getContentPane().add((Component)textpanel, "Center");
                    JButton buttonOK = new JButton("OK");
                    buttonOK.setMnemonic('O');
                    buttonOK.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            dlg.setVisible(false);
                            GenericObjectEditorPopupMenu.this.updateEditor(editor, comp, customStringRepresentation, textpanel.getContent());
                        }
                    });
                    JButton buttonCancel = new JButton("Cancel");
                    buttonCancel.setMnemonic('C');
                    buttonCancel.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            dlg.setVisible(false);
                        }
                    });
                    JPanel panel = new JPanel(new FlowLayout(2));
                    panel.add(buttonOK);
                    panel.add(buttonCancel);
                    dlg.getContentPane().add((Component)panel, "South");
                    dlg.pack();
                    dlg.setSize(400, 300);
                    dlg.setLocationRelativeTo(comp);
                    dlg.setVisible(true);
                }
            });
            this.add(item);
        }
    }

    protected String getMenuItemText(boolean customStringRepresentation) {
        if (customStringRepresentation) {
            return "string representation";
        }
        return "setup";
    }

    protected boolean updateEditor(PropertyEditor editor, JComponent comp, boolean customStringRepresentation, String str) {
        boolean result = true;
        PropertyEditor actualEditor = editor;
        GenericArrayEditor gae = null;
        String[] parts = new String[]{};
        if (editor instanceof GenericArrayEditor) {
            gae = (GenericArrayEditor)editor;
            gae.removeAllObjects();
            actualEditor = gae.getElementEditor();
            parts = str.split("\n");
        }
        try {
            if (customStringRepresentation) {
                if (gae != null) {
                    for (String part : parts) {
                        gae.addObject(((CustomStringRepresentationHandler)((Object)actualEditor)).fromCustomStringRepresentation(part));
                    }
                } else {
                    editor.setValue(((CustomStringRepresentationHandler)((Object)editor)).fromCustomStringRepresentation(str));
                }
            } else if (gae != null) {
                for (String part : parts) {
                    gae.addObject(OptionUtils.forString(Object.class, part));
                }
            } else {
                editor.setValue(OptionUtils.forString(Object.class, str));
            }
            editor.setValue(editor.getValue());
            comp.repaint();
            this.notifyChangeListeners();
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
            GUIHelper.showErrorMessage(comp, "Error processing " + this.getMenuItemText(customStringRepresentation) + " from clipboard:\n" + e);
        }
        return result;
    }

    protected boolean getCanChangeClassInDialog(PropertyEditor editor) {
        AbstractGenericObjectEditorHandler handler = AbstractGenericObjectEditorHandler.getHandler(editor);
        return handler.getCanChangeClassInDialog(editor);
    }

    public void addChangeListener(ChangeListener l) {
        this.m_ChangeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.m_ChangeListeners.remove(l);
    }

    protected void notifyChangeListeners() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.m_ChangeListeners) {
            l.stateChanged(e);
        }
    }
}

