/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.gui.core.ClearableModel;
import adams.gui.core.CustomSearchTableModel;
import adams.gui.core.SearchParameters;
import adams.gui.selection.AbstractTableBasedSelectionPanel;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public abstract class AbstractManagementTableModel<T extends Comparable>
extends AbstractTableBasedSelectionPanel.AbstractSelectionTableModel<T>
implements ClearableModel,
CustomSearchTableModel {
    private static final long serialVersionUID = 7481209191067222765L;
    protected Vector<T> m_Values;

    public AbstractManagementTableModel() {
        this(new Vector());
    }

    public AbstractManagementTableModel(T[] values) {
        this(new Vector<T>(Arrays.asList(values)));
    }

    public AbstractManagementTableModel(Vector<T> values) {
        this.m_Values = (Vector)values.clone();
        Collections.sort(this.m_Values);
    }

    @Override
    public int getRowCount() {
        return this.m_Values.size();
    }

    @Override
    public abstract int getColumnCount();

    @Override
    public abstract String getColumnName(int var1);

    public abstract Class getColumnClass(int var1);

    @Override
    public abstract Object getValueAt(int var1, int var2);

    @Override
    public T getItemAt(int row) {
        if (row >= 0 && row < this.m_Values.size()) {
            return (T)((Comparable)this.m_Values.get(row));
        }
        return null;
    }

    @Override
    public int indexOf(T value) {
        int result = -1;
        if (value != null) {
            for (int i = 0; i < this.m_Values.size(); ++i) {
                if (!value.equals(this.m_Values.get(i))) continue;
                result = i;
                break;
            }
        }
        return result;
    }

    @Override
    public abstract boolean isSearchMatch(SearchParameters var1, int var2);

    @Override
    public void clear() {
        this.m_Values = new Vector();
        this.fireTableDataChanged();
    }

    public void add(T value) {
        if (this.m_Values.contains(value)) {
            return;
        }
        this.m_Values.add(value);
        Collections.sort(this.m_Values);
        this.fireTableDataChanged();
    }

    public void addAll(List<T> values) {
        boolean modified = false;
        for (Comparable value : values) {
            if (this.m_Values.contains(value)) continue;
            modified = true;
            this.m_Values.add(value);
        }
        if (!modified) {
            return;
        }
        Collections.sort(this.m_Values);
        this.fireTableDataChanged();
    }
}

