/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.env.Environment;
import adams.gui.core.BaseTree;
import adams.gui.core.BaseTreeNode;
import java.awt.Component;
import java.awt.Container;

public class ContainerNesting {
    protected static String getLabel(Component comp) {
        String result = comp.getClass().getName();
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            result = cont.getLayout() != null ? result + " [" + cont.getLayout().getClass().getName() + "]" : result + " [no layout manager]";
        }
        result = result + ": " + (comp.isVisible() ? "visible" : "hidden");
        return result;
    }

    protected static BaseTreeNode analyze(BaseTreeNode parent, Component comp) {
        BaseTreeNode result = new BaseTreeNode(ContainerNesting.getLabel(comp));
        if (parent != null) {
            parent.add(result);
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                ContainerNesting.analyze(result, cont.getComponent(i));
            }
        }
        return result;
    }

    public static BaseTree analyze(Container cont) {
        BaseTreeNode root = ContainerNesting.analyze(null, cont);
        BaseTree result = new BaseTree(root);
        return result;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("\nUsage: " + ContainerNesting.class.getName() + " <environment class> <class-name>\n");
            System.exit(1);
        }
        System.err.println("Setting up environment...");
        Environment.setEnvironmentClass(Class.forName(args[0]));
        System.err.println("Analyzing container...");
        Container cont = (Container)Class.forName(args[1]).newInstance();
        BaseTree tree = ContainerNesting.analyze(cont);
        System.out.println(tree);
        System.exit(0);
    }
}

