/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.hadoop.fs.FSInputStream;

public abstract class ByteRangeInputStream
extends FSInputStream {
    protected InputStream in;
    protected URLOpener originalURL;
    protected URLOpener resolvedURL;
    protected long startPos = 0L;
    protected long currentPos = 0L;
    protected long filelength;
    StreamStatus status = StreamStatus.SEEK;

    public ByteRangeInputStream(URLOpener o, URLOpener r) {
        this.originalURL = o;
        this.resolvedURL = r;
    }

    protected abstract void checkResponseCode(HttpURLConnection var1) throws IOException;

    protected abstract URL getResolvedUrl(HttpURLConnection var1) throws IOException;

    private InputStream getInputStream() throws IOException {
        if (this.status != StreamStatus.NORMAL) {
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
            URLOpener opener = this.resolvedURL.getURL() == null ? this.originalURL : this.resolvedURL;
            HttpURLConnection connection = opener.openConnection(this.startPos);
            connection.connect();
            this.checkResponseCode(connection);
            String cl = connection.getHeaderField("Content-Length");
            this.filelength = cl == null ? -1L : Long.parseLong(cl);
            this.in = connection.getInputStream();
            this.resolvedURL.setURL(this.getResolvedUrl(connection));
            this.status = StreamStatus.NORMAL;
        }
        return this.in;
    }

    private void update(boolean isEOF, int n) throws IOException {
        if (!isEOF) {
            this.currentPos += (long)n;
        } else if (this.currentPos < this.filelength) {
            throw new IOException("Got EOF but currentPos = " + this.currentPos + " < filelength = " + this.filelength);
        }
    }

    @Override
    public int read() throws IOException {
        int b = this.getInputStream().read();
        this.update(b == -1, 1);
        return b;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos != this.currentPos) {
            this.startPos = pos;
            this.currentPos = pos;
            this.status = StreamStatus.SEEK;
        }
    }

    @Override
    public long getPos() throws IOException {
        return this.currentPos;
    }

    @Override
    public boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    static enum StreamStatus {
        NORMAL,
        SEEK;

    }

    public static abstract class URLOpener {
        protected URL url;

        public URLOpener(URL u) {
            this.url = u;
        }

        public void setURL(URL u) {
            this.url = u;
        }

        public URL getURL() {
            return this.url;
        }

        protected abstract HttpURLConnection openConnection() throws IOException;

        protected abstract HttpURLConnection openConnection(long var1) throws IOException;
    }
}

