/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.namenode.BlocksMap;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectoryWithQuota;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.NameCache;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.util.ByteArray;

class FSDirectory
implements FSConstants,
Closeable {
    final FSNamesystem namesystem;
    final INodeDirectoryWithQuota rootDir;
    FSImage fsImage;
    private boolean ready = false;
    private final int lsLimit;
    private final NameCache<ByteArray> nameCache;

    FSDirectory(FSNamesystem ns, Configuration conf) {
        this(new FSImage(), ns, conf);
        this.fsImage.setCheckpointDirectories(FSImage.getCheckpointDirs(conf, null), FSImage.getCheckpointEditsDirs(conf, null));
    }

    FSDirectory(FSImage fsImage, FSNamesystem ns, Configuration conf) {
        this.rootDir = new INodeDirectoryWithQuota("", ns.createFsOwnerPermissions(new FsPermission(493)), Integer.MAX_VALUE, -1L);
        this.fsImage = fsImage;
        fsImage.setRestoreRemovedDirs(conf.getBoolean("dfs.namenode.name.dir.restore", false));
        this.namesystem = ns;
        int configuredLimit = conf.getInt("dfs.ls.limit", 1000);
        this.lsLimit = configuredLimit > 0 ? configuredLimit : 1000;
        int threshold = conf.getInt("dfs.namenode.name.cache.threshold", 10);
        NameNode.LOG.info((Object)("Caching file names occuring more than " + threshold + " times "));
        this.nameCache = new NameCache(threshold);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadFSImage(Collection<File> dataDirs, Collection<File> editsDirs, HdfsConstants.StartupOption startOpt) throws IOException {
        if (startOpt == HdfsConstants.StartupOption.FORMAT) {
            this.fsImage.setStorageDirectories(dataDirs, editsDirs);
            this.fsImage.format();
            startOpt = HdfsConstants.StartupOption.REGULAR;
        }
        try {
            if (this.fsImage.recoverTransitionRead(dataDirs, editsDirs, startOpt)) {
                this.fsImage.saveNamespace(true);
            }
            FSEditLog editLog = this.fsImage.getEditLog();
            assert (editLog != null) : "editLog must be initialized";
            if (!editLog.isOpen()) {
                editLog.open();
            }
            this.fsImage.setCheckpointDirectories(null, null);
        }
        catch (IOException e) {
            this.fsImage.close();
            throw e;
        }
        FSDirectory fSDirectory = this;
        synchronized (fSDirectory) {
            this.ready = true;
            this.nameCache.initialized();
            this.notifyAll();
        }
    }

    private void incrDeletedFileCount(int count) {
        if (this.namesystem != null) {
            NameNode.getNameNodeMetrics().incrFilesDeleted(count);
        }
    }

    @Override
    public void close() throws IOException {
        this.fsImage.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForReady() {
        if (!this.ready) {
            FSDirectory fSDirectory = this;
            synchronized (fSDirectory) {
                while (!this.ready) {
                    try {
                        this.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INodeFileUnderConstruction addFile(String path, PermissionStatus permissions, short replication, long preferredBlockSize, String clientName, String clientMachine, DatanodeDescriptor clientNode, long generationStamp) throws IOException {
        this.waitForReady();
        long modTime = FSNamesystem.now();
        if (!this.mkdirs(new Path(path).getParent().toString(), permissions, true, modTime)) {
            return null;
        }
        INodeFileUnderConstruction newNode = new INodeFileUnderConstruction(permissions, replication, preferredBlockSize, modTime, clientName, clientMachine, clientNode);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            newNode = this.addNode(path, newNode, -1L, false);
        }
        if (newNode == null) {
            NameNode.stateChangeLog.info((Object)("DIR* FSDirectory.addFile: failed to add " + path + " to the file system"));
            return null;
        }
        this.fsImage.getEditLog().logOpenFile(path, newNode);
        NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.addFile: " + path + " is added to the file system"));
        return newNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INode unprotectedAddFile(String path, PermissionStatus permissions, Block[] blocks, short replication, long modificationTime, long atime, long preferredBlockSize) {
        INode newNode;
        long diskspace = -1L;
        if (blocks == null) {
            newNode = new INodeDirectory(permissions, modificationTime);
        } else {
            newNode = new INodeFile(permissions, blocks.length, replication, modificationTime, atime, preferredBlockSize);
            diskspace = ((INodeFile)newNode).diskspaceConsumed(blocks);
        }
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            try {
                newNode = this.addNode(path, newNode, diskspace, false);
                if (newNode != null && blocks != null) {
                    int nrBlocks = blocks.length;
                    INodeFile newF = (INodeFile)newNode;
                    for (int i = 0; i < nrBlocks; ++i) {
                        newF.setBlock(i, this.namesystem.blocksMap.addINode(blocks[i], newF));
                    }
                }
            }
            catch (IOException e) {
                return null;
            }
            return newNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INodeDirectory addToParent(String src, INodeDirectory parentINode, PermissionStatus permissions, Block[] blocks, short replication, long modificationTime, long atime, long nsQuota, long dsQuota, long preferredBlockSize) {
        INode newNode = blocks == null ? (nsQuota >= 0L || dsQuota >= 0L ? new INodeDirectoryWithQuota(permissions, modificationTime, nsQuota, dsQuota) : new INodeDirectory(permissions, modificationTime)) : new INodeFile(permissions, blocks.length, replication, modificationTime, atime, preferredBlockSize);
        INodeDirectory newParent = null;
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            try {
                newParent = this.rootDir.addToParent(src, newNode, parentINode, false);
                this.cacheName(newNode);
            }
            catch (FileNotFoundException e) {
                return null;
            }
            if (newParent == null) {
                return null;
            }
            if (blocks != null) {
                int nrBlocks = blocks.length;
                INode newF = newNode;
                for (int i = 0; i < nrBlocks; ++i) {
                    ((INodeFile)newF).setBlock(i, this.namesystem.blocksMap.addINode(blocks[i], (INodeFile)newF));
                }
            }
        }
        return newParent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Block addBlock(String path, INode[] inodes, Block block) throws IOException {
        this.waitForReady();
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INodeFile fileNode = (INodeFile)inodes[inodes.length - 1];
            this.updateCount(inodes, inodes.length - 1, 0L, fileNode.getPreferredBlockSize() * (long)fileNode.getReplication(), true);
            this.namesystem.blocksMap.addINode(block, fileNode);
            BlocksMap.BlockInfo blockInfo = this.namesystem.blocksMap.getStoredBlock(block);
            fileNode.addBlock(blockInfo);
            NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.addFile: " + path + " with " + block + " block is added to the in-memory " + "file system"));
        }
        return block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void persistBlocks(String path, INodeFileUnderConstruction file) throws IOException {
        this.waitForReady();
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            this.fsImage.getEditLog().logOpenFile(path, file);
            NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.persistBlocks: " + path + " with " + file.getBlocks().length + " blocks is persisted to the file system"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeFile(String path, INodeFile file) throws IOException {
        this.waitForReady();
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            this.fsImage.getEditLog().logCloseFile(path, file);
            if (NameNode.stateChangeLog.isDebugEnabled()) {
                NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.closeFile: " + path + " with " + file.getBlocks().length + " blocks is persisted to the file system"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeBlock(String path, INodeFileUnderConstruction fileNode, Block block) throws IOException {
        this.waitForReady();
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            fileNode.removeBlock(block);
            this.namesystem.blocksMap.removeINode(block);
            this.namesystem.corruptReplicas.removeFromCorruptReplicasMap(block);
            this.fsImage.getEditLog().logOpenFile(path, fileNode);
            NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.addFile: " + path + " with " + block + " block is added to the file system"));
        }
        return true;
    }

    boolean renameTo(String src, String dst) throws QuotaExceededException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.renameTo: " + src + " to " + dst));
        }
        this.waitForReady();
        long now = FSNamesystem.now();
        if (!this.unprotectedRenameTo(src, dst, now)) {
            return false;
        }
        this.fsImage.getEditLog().logRename(src, dst, now);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean unprotectedRenameTo(String src, String dst, long timestamp) throws QuotaExceededException {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            String srcChildName;
            INode srcChild;
            INode dstChild;
            INode[] srcInodes;
            block17: {
                boolean bl;
                block18: {
                    INode[] dstInodes;
                    byte[][] dstComponents;
                    block15: {
                        boolean bl2;
                        block16: {
                            srcInodes = this.rootDir.getExistingPathINodes(src);
                            if (srcInodes[srcInodes.length - 1] == null) {
                                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because source does not exist"));
                                return false;
                            }
                            if (srcInodes.length == 1) {
                                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because source is the root"));
                                return false;
                            }
                            if (this.isDir(dst)) {
                                dst = dst + "/" + new Path(src).getName();
                            }
                            if (dst.equals(src)) {
                                return true;
                            }
                            if (dst.startsWith(src) && dst.charAt(src.length()) == '/') {
                                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because destination starts with src"));
                                return false;
                            }
                            dstComponents = INode.getPathComponents(dst);
                            dstInodes = new INode[dstComponents.length];
                            this.rootDir.getExistingPathINodes(dstComponents, dstInodes);
                            if (dstInodes[dstInodes.length - 1] != null) {
                                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because destination exists"));
                                return false;
                            }
                            if (dstInodes[dstInodes.length - 2] == null) {
                                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because destination's parent does not exist"));
                                return false;
                            }
                            this.verifyQuotaForRename(srcInodes, dstInodes);
                            dstChild = null;
                            srcChild = null;
                            srcChildName = null;
                            try {
                                srcChild = this.removeChild(srcInodes, srcInodes.length - 1);
                                if (srcChild != null) break block15;
                                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because the source can not be removed"));
                                bl2 = false;
                                if (dstChild != null || srcChild == null) break block16;
                                srcChild.setLocalName(srcChildName);
                                this.addChildNoQuotaCheck(srcInodes, srcInodes.length - 1, srcChild, -1L, false);
                            }
                            catch (Throwable throwable) {
                                if (dstChild == null && srcChild != null) {
                                    srcChild.setLocalName(srcChildName);
                                    this.addChildNoQuotaCheck(srcInodes, srcInodes.length - 1, srcChild, -1L, false);
                                }
                                throw throwable;
                            }
                        }
                        return bl2;
                    }
                    srcChildName = srcChild.getLocalName();
                    srcChild.setLocalName(dstComponents[dstInodes.length - 1]);
                    dstChild = this.addChildNoQuotaCheck(dstInodes, dstInodes.length - 1, srcChild, -1L, false);
                    if (dstChild == null) break block17;
                    srcChild = null;
                    if (NameNode.stateChangeLog.isDebugEnabled()) {
                        NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.unprotectedRenameTo: " + src + " is renamed to " + dst));
                    }
                    srcInodes[srcInodes.length - 2].setModificationTime(timestamp);
                    dstInodes[dstInodes.length - 2].setModificationTime(timestamp);
                    bl = true;
                    if (dstChild != null || srcChild == null) break block18;
                    srcChild.setLocalName(srcChildName);
                    this.addChildNoQuotaCheck(srcInodes, srcInodes.length - 1, srcChild, -1L, false);
                }
                return bl;
            }
            if (dstChild == null && srcChild != null) {
                srcChild.setLocalName(srcChildName);
                this.addChildNoQuotaCheck(srcInodes, srcInodes.length - 1, srcChild, -1L, false);
            }
            NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst));
            return false;
        }
    }

    Block[] setReplication(String src, short replication, int[] oldReplication) throws IOException {
        this.waitForReady();
        Block[] fileBlocks = this.unprotectedSetReplication(src, replication, oldReplication);
        if (fileBlocks != null) {
            this.fsImage.getEditLog().logSetReplication(src, replication);
        }
        return fileBlocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Block[] unprotectedSetReplication(String src, short replication, int[] oldReplication) throws IOException {
        if (oldReplication == null) {
            oldReplication = new int[]{-1};
        }
        Block[] fileBlocks = null;
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode[] inodes = this.rootDir.getExistingPathINodes(src);
            INode inode = inodes[inodes.length - 1];
            if (inode == null) {
                return null;
            }
            if (inode.isDirectory()) {
                return null;
            }
            INodeFile fileNode = (INodeFile)inode;
            oldReplication[0] = fileNode.getReplication();
            long dsDelta = (long)(replication - oldReplication[0]) * (fileNode.diskspaceConsumed() / (long)oldReplication[0]);
            this.updateCount(inodes, inodes.length - 1, 0L, dsDelta, true);
            fileNode.setReplication(replication);
            fileBlocks = fileNode.getBlocks();
        }
        return fileBlocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getPreferredBlockSize(String filename) throws IOException {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode fileNode = this.rootDir.getNode(filename);
            if (fileNode == null) {
                throw new IOException("Unknown file: " + filename);
            }
            if (fileNode.isDirectory()) {
                throw new IOException("Getting block size of a directory: " + filename);
            }
            return ((INodeFile)fileNode).getPreferredBlockSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean exists(String src) {
        src = this.normalizePath(src);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode inode = this.rootDir.getNode(src);
            if (inode == null) {
                return false;
            }
            return inode.isDirectory() ? true : ((INodeFile)inode).getBlocks() != null;
        }
    }

    void setPermission(String src, FsPermission permission) throws IOException {
        this.unprotectedSetPermission(src, permission);
        this.fsImage.getEditLog().logSetPermissions(src, permission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unprotectedSetPermission(String src, FsPermission permissions) throws FileNotFoundException {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode inode = this.rootDir.getNode(src);
            if (inode == null) {
                throw new FileNotFoundException("File does not exist: " + src);
            }
            inode.setPermission(permissions);
        }
    }

    void setOwner(String src, String username, String groupname) throws IOException {
        this.unprotectedSetOwner(src, username, groupname);
        this.fsImage.getEditLog().logSetOwner(src, username, groupname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unprotectedSetOwner(String src, String username, String groupname) throws FileNotFoundException {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode inode = this.rootDir.getNode(src);
            if (inode == null) {
                throw new FileNotFoundException("File does not exist: " + src);
            }
            if (username != null) {
                inode.setUser(username);
            }
            if (groupname != null) {
                inode.setGroup(groupname);
            }
        }
    }

    boolean delete(String src) {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.delete: " + src));
        }
        this.waitForReady();
        long now = FSNamesystem.now();
        int filesRemoved = this.unprotectedDelete(src, now);
        if (filesRemoved <= 0) {
            return false;
        }
        this.incrDeletedFileCount(filesRemoved);
        this.fsImage.getEditLog().logDelete(src, now);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDirEmpty(String src) {
        boolean dirNotEmpty = true;
        if (!this.isDir(src)) {
            return true;
        }
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode targetNode = this.rootDir.getNode(src);
            assert (targetNode != null) : "should be taken care in isDir() above";
            if (((INodeDirectory)targetNode).getChildren().size() != 0) {
                dirNotEmpty = false;
            }
        }
        return dirNotEmpty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int unprotectedDelete(String src, long modificationTime) {
        src = this.normalizePath(src);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode[] inodes = this.rootDir.getExistingPathINodes(src);
            INode targetNode = inodes[inodes.length - 1];
            if (targetNode == null) {
                NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.unprotectedDelete: failed to remove " + src + " because it does not exist"));
                return 0;
            }
            if (inodes.length == 1) {
                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedDelete: failed to remove " + src + " because the root is not allowed to be deleted"));
                return 0;
            }
            try {
                this.removeChild(inodes, inodes.length - 1);
                inodes[inodes.length - 2].setModificationTime(modificationTime);
                ArrayList<Block> v = new ArrayList<Block>();
                int filesRemoved = targetNode.collectSubtreeBlocksAndClear(v);
                this.namesystem.removePathAndBlocks(src, v);
                if (NameNode.stateChangeLog.isDebugEnabled()) {
                    NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.unprotectedDelete: " + src + " is removed"));
                }
                return filesRemoved;
            }
            catch (IOException e) {
                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedDelete: failed to remove " + src + " because " + e.getMessage()));
                return 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replaceNode(String path, INodeFile oldnode, INodeFile newnode) throws IOException {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            if (!oldnode.removeNode()) {
                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.replaceNode: failed to remove " + path));
                throw new IOException("FSDirectory.replaceNode: failed to remove " + path);
            }
            this.rootDir.addNode(path, newnode);
            int index = 0;
            for (BlocksMap.BlockInfo b : newnode.getBlocks()) {
                BlocksMap.BlockInfo info = this.namesystem.blocksMap.addINode(b, newnode);
                newnode.setBlock(index, info);
                ++index;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DirectoryListing getListing(String src, byte[] startAfter) {
        String srcs = this.normalizePath(src);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode targetNode = this.rootDir.getNode(srcs);
            if (targetNode == null) {
                return null;
            }
            if (!targetNode.isDirectory()) {
                return new DirectoryListing(new HdfsFileStatus[]{FSDirectory.createFileStatus(HdfsFileStatus.EMPTY_NAME, targetNode)}, 0);
            }
            INodeDirectory dirInode = (INodeDirectory)targetNode;
            List<INode> contents = dirInode.getChildren();
            int startChild = dirInode.nextChild(startAfter);
            int totalNumChildren = contents.size();
            int numOfListing = Math.min(totalNumChildren - startChild, this.lsLimit);
            HdfsFileStatus[] listing = new HdfsFileStatus[numOfListing];
            for (int i = 0; i < numOfListing; ++i) {
                INode cur = contents.get(startChild + i);
                listing[i] = FSDirectory.createFileStatus(cur.name, cur);
            }
            return new DirectoryListing(listing, totalNumChildren - startChild - numOfListing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HdfsFileStatus getFileInfo(String src) {
        String srcs = this.normalizePath(src);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode targetNode = this.rootDir.getNode(srcs);
            if (targetNode == null) {
                return null;
            }
            return FSDirectory.createFileStatus(HdfsFileStatus.EMPTY_NAME, targetNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Block[] getFileBlocks(String src) {
        this.waitForReady();
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode targetNode = this.rootDir.getNode(src);
            if (targetNode == null) {
                return null;
            }
            if (targetNode.isDirectory()) {
                return null;
            }
            return ((INodeFile)targetNode).getBlocks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INodeFile getFileINode(String src) {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode inode = this.rootDir.getNode(src);
            if (inode == null || inode.isDirectory()) {
                return null;
            }
            return (INodeFile)inode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INode[] getExistingPathINodes(String path) {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            return this.rootDir.getExistingPathINodes(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isValidToCreate(String src) {
        String srcs = this.normalizePath(src);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            return srcs.startsWith("/") && !srcs.endsWith("/") && this.rootDir.getNode(srcs) == null;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDir(String src) {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode node = this.rootDir.getNode(this.normalizePath(src));
            return node != null && node.isDirectory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateSpaceConsumed(String path, long nsDelta, long dsDelta) throws QuotaExceededException, FileNotFoundException {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode[] inodes = this.rootDir.getExistingPathINodes(path);
            int len = inodes.length;
            if (inodes[len - 1] == null) {
                throw new FileNotFoundException(path + " does not exist under rootDir.");
            }
            this.updateCount(inodes, len - 1, nsDelta, dsDelta, true);
        }
    }

    private void updateCount(INode[] inodes, int numOfINodes, long nsDelta, long dsDelta, boolean checkQuota) throws QuotaExceededException {
        if (!this.ready) {
            return;
        }
        if (numOfINodes > inodes.length) {
            numOfINodes = inodes.length;
        }
        if (checkQuota) {
            this.verifyQuota(inodes, numOfINodes, nsDelta, dsDelta, null);
        }
        for (int i = 0; i < numOfINodes; ++i) {
            if (!inodes[i].isQuotaSet()) continue;
            INodeDirectoryWithQuota node = (INodeDirectoryWithQuota)inodes[i];
            node.updateNumItemsInTree(nsDelta, dsDelta);
        }
    }

    private void updateCountNoQuotaCheck(INode[] inodes, int numOfINodes, long nsDelta, long dsDelta) {
        try {
            this.updateCount(inodes, numOfINodes, nsDelta, dsDelta, false);
        }
        catch (QuotaExceededException e) {
            NameNode.LOG.warn((Object)"FSDirectory.updateCountNoQuotaCheck - unexpected ", (Throwable)e);
        }
    }

    private static String getFullPathName(INode[] inodes, int pos) {
        StringBuilder fullPathName = new StringBuilder();
        for (int i = 1; i <= pos; ++i) {
            fullPathName.append('/').append(inodes[i].getLocalName());
        }
        return fullPathName.toString();
    }

    static String getFullPathName(INode inode) {
        int depth = 0;
        INode i = inode;
        while (i != null) {
            ++depth;
            i = i.parent;
        }
        INode[] inodes = new INode[depth];
        for (int i2 = 0; i2 < depth; ++i2) {
            inodes[depth - i2 - 1] = inode;
            inode = inode.parent;
        }
        return FSDirectory.getFullPathName(inodes, depth - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean mkdirs(String src, PermissionStatus permissions, boolean inheritPermission, long now) throws FileNotFoundException, QuotaExceededException {
        src = this.normalizePath(src);
        String[] names = INode.getPathNames(src);
        byte[][] components = INode.getPathComponents(names);
        INode[] inodes = new INode[components.length];
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            int i;
            this.rootDir.getExistingPathINodes(components, inodes);
            StringBuilder pathbuilder = new StringBuilder();
            for (i = 1; i < inodes.length && inodes[i] != null; ++i) {
                pathbuilder.append("/" + names[i]);
                if (inodes[i].isDirectory()) continue;
                throw new FileNotFoundException("Parent path is not a directory: " + pathbuilder);
            }
            while (i < inodes.length) {
                pathbuilder.append("/" + names[i]);
                String cur = pathbuilder.toString();
                this.unprotectedMkdir(inodes, i, components[i], permissions, inheritPermission || i != components.length - 1, now);
                if (inodes[i] == null) {
                    return false;
                }
                if (this.namesystem != null) {
                    NameNode.getNameNodeMetrics().incrNumFilesCreated();
                }
                this.fsImage.getEditLog().logMkDir(cur, inodes[i]);
                NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.mkdirs: created directory " + cur));
                ++i;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INode unprotectedMkdir(String src, PermissionStatus permissions, long timestamp) throws QuotaExceededException {
        byte[][] components = INode.getPathComponents(src);
        INode[] inodes = new INode[components.length];
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            this.rootDir.getExistingPathINodes(components, inodes);
            this.unprotectedMkdir(inodes, inodes.length - 1, components[inodes.length - 1], permissions, false, timestamp);
            return inodes[inodes.length - 1];
        }
    }

    private void unprotectedMkdir(INode[] inodes, int pos, byte[] name, PermissionStatus permission, boolean inheritPermission, long timestamp) throws QuotaExceededException {
        inodes[pos] = this.addChild(inodes, pos, new INodeDirectory(name, permission, timestamp), -1L, inheritPermission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends INode> T addNode(String src, T child, long childDiskspace, boolean inheritPermission) throws QuotaExceededException {
        byte[][] components = INode.getPathComponents(src);
        byte[] path = components[components.length - 1];
        child.setLocalName(path);
        this.cacheName(child);
        INode[] inodes = new INode[components.length];
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            this.rootDir.getExistingPathINodes(components, inodes);
            return this.addChild(inodes, inodes.length - 1, child, childDiskspace, inheritPermission);
        }
    }

    private void verifyQuota(INode[] inodes, int pos, long nsDelta, long dsDelta, INode commonAncestor) throws QuotaExceededException {
        int i;
        if (!this.ready) {
            return;
        }
        if (pos > inodes.length) {
            pos = inodes.length;
        }
        try {
            for (i = pos - 1; i >= 0; --i) {
                if (commonAncestor == inodes[i]) {
                    return;
                }
                if (!inodes[i].isQuotaSet()) continue;
                INodeDirectoryWithQuota node = (INodeDirectoryWithQuota)inodes[i];
                node.verifyQuota(nsDelta, dsDelta);
            }
        }
        catch (QuotaExceededException e) {
            e.setPathName(FSDirectory.getFullPathName(inodes, i));
            throw e;
        }
    }

    private void verifyQuotaForRename(INode[] srcInodes, INode[] dstInodes) throws QuotaExceededException {
        if (!this.ready) {
            return;
        }
        INode srcInode = srcInodes[srcInodes.length - 1];
        INode commonAncestor = null;
        int i = 0;
        while (srcInodes[i] == dstInodes[i]) {
            commonAncestor = srcInodes[i];
            ++i;
        }
        INode.DirCounts counts = new INode.DirCounts();
        srcInode.spaceConsumedInTree(counts);
        this.verifyQuota(dstInodes, dstInodes.length - 1, counts.getNsCount(), counts.getDsCount(), commonAncestor);
    }

    private <T extends INode> T addChild(INode[] pathComponents, int pos, T child, long childDiskspace, boolean inheritPermission, boolean checkQuota) throws QuotaExceededException {
        INode.DirCounts counts = new INode.DirCounts();
        child.spaceConsumedInTree(counts);
        if (childDiskspace < 0L) {
            childDiskspace = counts.getDsCount();
        }
        this.updateCount(pathComponents, pos, counts.getNsCount(), childDiskspace, checkQuota);
        T addedNode = ((INodeDirectory)pathComponents[pos - 1]).addChild(child, inheritPermission);
        if (addedNode == null) {
            this.updateCount(pathComponents, pos, -counts.getNsCount(), -childDiskspace, true);
        }
        return addedNode;
    }

    private <T extends INode> T addChild(INode[] pathComponents, int pos, T child, long childDiskspace, boolean inheritPermission) throws QuotaExceededException {
        return this.addChild(pathComponents, pos, child, childDiskspace, inheritPermission, true);
    }

    private <T extends INode> T addChildNoQuotaCheck(INode[] pathComponents, int pos, T child, long childDiskspace, boolean inheritPermission) {
        T inode = null;
        try {
            inode = this.addChild(pathComponents, pos, child, childDiskspace, inheritPermission, false);
        }
        catch (QuotaExceededException e) {
            NameNode.LOG.warn((Object)"FSDirectory.addChildNoQuotaCheck - unexpected", (Throwable)e);
        }
        return inode;
    }

    private INode removeChild(INode[] pathComponents, int pos) {
        INode removedNode = ((INodeDirectory)pathComponents[pos - 1]).removeChild(pathComponents[pos]);
        if (removedNode != null) {
            INode.DirCounts counts = new INode.DirCounts();
            removedNode.spaceConsumedInTree(counts);
            this.updateCountNoQuotaCheck(pathComponents, pos, -counts.getNsCount(), -counts.getDsCount());
        }
        return removedNode;
    }

    String normalizePath(String src) {
        if (src.length() > 1 && src.endsWith("/")) {
            src = src.substring(0, src.length() - 1);
        }
        return src;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ContentSummary getContentSummary(String src) throws IOException {
        String srcs = this.normalizePath(src);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode targetNode = this.rootDir.getNode(srcs);
            if (targetNode == null) {
                throw new FileNotFoundException("File does not exist: " + srcs);
            }
            return targetNode.computeContentSummary();
        }
    }

    void updateCountForINodeWithQuota() {
        FSDirectory.updateCountForINodeWithQuota(this.rootDir, new INode.DirCounts(), new ArrayList<INode>(50));
    }

    private static void updateCountForINodeWithQuota(INodeDirectory dir, INode.DirCounts counts, ArrayList<INode> nodesInPath) {
        long parentNamespace = counts.nsCount;
        long parentDiskspace = counts.dsCount;
        counts.nsCount = 1L;
        counts.dsCount = 0L;
        nodesInPath.add(dir);
        for (INode child : dir.getChildren()) {
            if (child.isDirectory()) {
                FSDirectory.updateCountForINodeWithQuota((INodeDirectory)child, counts, nodesInPath);
                continue;
            }
            ++counts.nsCount;
            counts.dsCount += ((INodeFile)child).diskspaceConsumed();
        }
        if (dir.isQuotaSet()) {
            ((INodeDirectoryWithQuota)dir).setSpaceConsumed(counts.nsCount, counts.dsCount);
            if (dir.getNsQuota() >= 0L && counts.nsCount > dir.getNsQuota() || dir.getDsQuota() >= 0L && counts.dsCount > dir.getDsQuota()) {
                StringBuilder path = new StringBuilder(512);
                for (INode n : nodesInPath) {
                    path.append('/');
                    path.append(n.getLocalName());
                }
                NameNode.LOG.warn((Object)("Quota violation in image for " + path + " (Namespace quota : " + dir.getNsQuota() + " consumed : " + counts.nsCount + ")" + " (Diskspace quota : " + dir.getDsQuota() + " consumed : " + counts.dsCount + ")."));
            }
        }
        nodesInPath.remove(nodesInPath.size() - 1);
        counts.nsCount += parentNamespace;
        counts.dsCount += parentDiskspace;
    }

    INodeDirectory unprotectedSetQuota(String src, long nsQuota, long dsQuota) throws FileNotFoundException, QuotaExceededException {
        if (nsQuota < 0L && nsQuota != Long.MAX_VALUE && nsQuota < -1L || dsQuota < 0L && dsQuota != Long.MAX_VALUE && dsQuota < -1L) {
            throw new IllegalArgumentException("Illegal value for nsQuota or dsQuota : " + nsQuota + " and " + dsQuota);
        }
        String srcs = this.normalizePath(src);
        INode[] inodes = this.rootDir.getExistingPathINodes(src);
        INode targetNode = inodes[inodes.length - 1];
        if (targetNode == null) {
            throw new FileNotFoundException("Directory does not exist: " + srcs);
        }
        if (!targetNode.isDirectory()) {
            throw new FileNotFoundException("Cannot set quota on a file: " + srcs);
        }
        if (targetNode.isRoot() && nsQuota == -1L) {
            throw new IllegalArgumentException("Cannot clear namespace quota on root.");
        }
        INodeDirectory dirNode = (INodeDirectory)targetNode;
        long oldNsQuota = dirNode.getNsQuota();
        long oldDsQuota = dirNode.getDsQuota();
        if (nsQuota == Long.MAX_VALUE) {
            nsQuota = oldNsQuota;
        }
        if (dsQuota == Long.MAX_VALUE) {
            dsQuota = oldDsQuota;
        }
        if (dirNode instanceof INodeDirectoryWithQuota) {
            ((INodeDirectoryWithQuota)dirNode).setQuota(nsQuota, dsQuota);
            if (!dirNode.isQuotaSet()) {
                INodeDirectory newNode = new INodeDirectory(dirNode);
                INodeDirectory parent = (INodeDirectory)inodes[inodes.length - 2];
                dirNode = newNode;
                parent.replaceChild(newNode);
            }
        } else {
            INodeDirectoryWithQuota newNode = new INodeDirectoryWithQuota(nsQuota, dsQuota, dirNode);
            INodeDirectory parent = (INodeDirectory)inodes[inodes.length - 2];
            dirNode = newNode;
            parent.replaceChild(newNode);
        }
        return oldNsQuota != nsQuota || oldDsQuota != dsQuota ? dirNode : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setQuota(String src, long nsQuota, long dsQuota) throws FileNotFoundException, QuotaExceededException {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INodeDirectory dir = this.unprotectedSetQuota(src, nsQuota, dsQuota);
            if (dir != null) {
                this.fsImage.getEditLog().logSetQuota(src, dir.getNsQuota(), dir.getDsQuota());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long totalInodes() {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            return this.rootDir.numItemsInTree();
        }
    }

    void setTimes(String src, INodeFile inode, long mtime, long atime, boolean force) throws IOException {
        if (this.unprotectedSetTimes(src, inode, mtime, atime, force)) {
            this.fsImage.getEditLog().logTimes(src, mtime, atime);
        }
    }

    boolean unprotectedSetTimes(String src, long mtime, long atime, boolean force) throws IOException {
        INodeFile inode = this.getFileINode(src);
        return this.unprotectedSetTimes(src, inode, mtime, atime, force);
    }

    private boolean unprotectedSetTimes(String src, INodeFile inode, long mtime, long atime, boolean force) throws IOException {
        boolean status = false;
        if (mtime != -1L) {
            inode.setModificationTimeForce(mtime);
            status = true;
        }
        if (atime != -1L) {
            long inodeTime = inode.getAccessTime();
            if (atime <= inodeTime + this.namesystem.getAccessTimePrecision() && !force) {
                status = false;
            } else {
                inode.setAccessTime(atime);
                status = true;
            }
        }
        return status;
    }

    private static HdfsFileStatus createFileStatus(byte[] path, INode node) {
        return new HdfsFileStatus(node.isDirectory() ? 0L : ((INodeFile)node).computeContentSummary().getLength(), node.isDirectory(), node.isDirectory() ? (short)0 : ((INodeFile)node).getReplication(), node.isDirectory() ? 0L : ((INodeFile)node).getPreferredBlockSize(), node.getModificationTime(), node.getAccessTime(), node.getFsPermission(), node.getUserName(), node.getGroupName(), path);
    }

    void cacheName(INode inode) {
        if (inode.isDirectory()) {
            return;
        }
        ByteArray name = new ByteArray(inode.getLocalNameBytes());
        if ((name = this.nameCache.put(name)) != null) {
            inode.setLocalName(name.getBytes());
        }
    }
}

