/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.installresource;

import de.intarsys.tools.file.TempTools;
import de.intarsys.tools.installresource.Install;
import de.intarsys.tools.stream.StreamTools;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;

public class InstallFileList
extends Install {
    public InstallFileList(String path, String name, boolean platformDependent) {
        super(path, name, platformDependent);
    }

    protected void loadEntry(File parent, String name) throws IOException {
        if (name.length() == 0 || name.startsWith("#")) {
            return;
        }
        Enumeration<URL> urls = this.find(name);
        if (urls != null && urls.hasMoreElements()) {
            URL url = urls.nextElement();
            File entryFile = new File(parent, name);
            File entryDir = entryFile.getParentFile();
            if (entryDir != null && !entryDir.exists()) {
                entryDir.mkdirs();
            }
            InstallFileList.copy(url, entryFile);
        }
    }

    protected void loadList(File parent, InputStream is) throws IOException {
        String entryName;
        StringBuilder sb = new StringBuilder();
        int i = is.read();
        while (i != -1) {
            if (i == 10) {
                entryName = sb.toString().trim();
                this.loadEntry(parent, entryName);
                sb.setLength(0);
                i = is.read();
                continue;
            }
            sb.append((char)i);
            i = is.read();
        }
        entryName = sb.toString().trim();
        this.loadEntry(parent, entryName);
    }

    protected File loadURL(URL url) throws IOException {
        InputStream is = url.openStream();
        try {
            File file = TempTools.createTempDir("dir", this.getName());
            this.loadList(file, is);
            File file2 = file;
            return file2;
        }
        finally {
            StreamTools.close(is);
        }
    }
}

