/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.Variables;
import adams.core.option.AbstractOption;
import adams.core.option.OptionManager;
import adams.core.option.OptionUtils;
import adams.event.VariableChangeEvent;
import adams.event.VariableChangeListener;
import adams.flow.core.FlowVariables;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Vector;

public abstract class AbstractArgumentOption
extends AbstractOption
implements VariableChangeListener {
    private static final long serialVersionUID = 8495236290921805608L;
    protected Class m_BaseClass = null;
    protected boolean m_Multiple = false;
    protected String m_Variable = null;
    protected boolean m_VariableModified = false;
    protected boolean m_VariableGlobalReference = false;

    protected AbstractArgumentOption(OptionManager owner, String commandline, String property, Object defValue) {
        this(owner, commandline, property, defValue, true);
    }

    protected AbstractArgumentOption(OptionManager owner, String commandline, String property, Object defValue, boolean outputDefValue) {
        super(owner, commandline, property, defValue, outputDefValue);
        if (this.getDescriptor() != null) {
            this.m_Multiple = this.getDescriptor().getReadMethod().getReturnType().isArray();
            this.m_BaseClass = this.isMultiple() ? this.getDescriptor().getPropertyType().getComponentType() : this.getDescriptor().getPropertyType();
        }
    }

    public boolean isMultiple() {
        return this.m_Multiple;
    }

    public boolean hasBaseClass() {
        return this.m_BaseClass != null;
    }

    public Class getBaseClass() {
        return this.m_BaseClass;
    }

    public boolean isVariableAttached() {
        return this.m_Variable != null;
    }

    public void setVariable(String value) {
        if (this.isMultiple()) {
            throw new IllegalArgumentException("Variables cannot be set for arrays!");
        }
        this.m_VariableGlobalReference = false;
        if (value != null) {
            this.m_Variable = Variables.extractName(value);
            this.m_VariableGlobalReference = FlowVariables.isGlobalReference(value);
        } else {
            this.m_Variable = null;
        }
    }

    public String getVariable() {
        if (this.m_Variable == null) {
            return null;
        }
        return Variables.padName(this.m_Variable);
    }

    public String getVariableName() {
        return this.m_Variable;
    }

    public boolean isVariableModified() {
        return this.isVariableAttached() && this.m_VariableModified;
    }

    public boolean isVariableGlobalReference() {
        return this.m_VariableGlobalReference;
    }

    @Override
    public void variableChanged(VariableChangeEvent e) {
        if (!this.isVariableAttached()) {
            return;
        }
        if (e.getName().equals(this.getVariableName())) {
            this.m_VariableModified = true;
        }
    }

    public String updateVariable() {
        Method method = this.getWriteMethod();
        if (method == null) {
            System.err.println("Failed to obtain write method for option '" + this.getCommandline() + "/" + this.getProperty() + ", cannot set variable value ('" + this.m_Variable + "')!");
            return "Write method not found";
        }
        if (!this.getOwner().getVariables().has(this.m_Variable)) {
            System.err.println("Variable '" + this.m_Variable + "' is not defined!");
            return "Variable '" + this.m_Variable + "' not defined";
        }
        try {
            method.invoke((Object)this.getOptionHandler(), this.valueOf(this.getOwner().getVariables().get(this.m_Variable)));
            this.m_VariableModified = false;
        }
        catch (Exception e) {
            System.err.println("Failed to set value for variable '" + this.m_Variable + "': " + this.getOwner().getVariables().get(this.m_Variable));
            e.printStackTrace();
            return "Failed to set value for variable '" + this.m_Variable + "'";
        }
        return null;
    }

    public abstract Object valueOf(String var1) throws Exception;

    public abstract String toString(Object var1);

    protected abstract boolean compareValues(Object var1, Object var2);

    protected boolean isDefaultValue(Object value) {
        boolean result;
        if (!OptionUtils.getSuppressDefaultValues()) {
            result = false;
        } else {
            result = true;
            if (this.isMultiple()) {
                boolean bl = result = Array.getLength(value) == Array.getLength(this.getDefaultValue());
                if (result) {
                    int len = Array.getLength(value);
                    for (int i = 0; i < len && (result = this.compareValues(Array.get(value, i), Array.get(this.getDefaultValue(), i))); ++i) {
                    }
                }
            } else {
                result = this.compareValues(value, this.getDefaultValue());
            }
        }
        return result;
    }

    public String[] toArray() {
        Vector<String> result = new Vector<String>();
        if (this.isVariableAttached()) {
            result.add("-" + this.getCommandline());
            result.add(this.getVariable());
        } else {
            Object currValue = this.getCurrentValue();
            if (!this.isDefaultValue(currValue)) {
                Object currValues = null;
                if (currValue != null) {
                    if (!this.isMultiple()) {
                        currValues = Array.newInstance(this.getBaseClass(), 1);
                        Array.set(currValues, 0, currValue);
                    } else {
                        currValues = currValue;
                    }
                    for (int i = 0; i < Array.getLength(currValues); ++i) {
                        result.add("-" + this.getCommandline());
                        result.add(this.toString(Array.get(currValues, i)));
                    }
                }
            }
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void cleanUp() {
        if (this.getOwner() != null && this.getOwner().getVariables() != null) {
            this.getOwner().getVariables().removeVariableChangeListener(this);
        }
        this.m_BaseClass = null;
        super.cleanUp();
    }

    public String toString() {
        return "-" + this.getCommandline() + "/" + this.getProperty() + " <arg>" + (this.isMultiple() ? " ..." : "");
    }
}

