/*
 * Decompiled with CFR 0.152.
 */
package adams.data.sequence;

import adams.core.Utils;
import adams.data.container.AbstractDataPoint;
import adams.data.container.DataPoint;

public class XYSequencePoint<X extends Number, Y extends Number>
extends AbstractDataPoint {
    private static final long serialVersionUID = 2354312871454097142L;
    protected String m_ID;
    protected X m_X;
    protected Y m_Y;

    public XYSequencePoint() {
        this(null, null);
    }

    public XYSequencePoint(X x, Y y) {
        this(null, x, y);
    }

    public XYSequencePoint(String id, X x, Y y) {
        this.setID(id);
        this.setX(x);
        this.setY(y);
    }

    public void setX(X value) {
        this.m_X = value;
    }

    public X getX() {
        return this.m_X;
    }

    public void setY(Y value) {
        this.m_Y = value;
    }

    public Y getY() {
        return this.m_Y;
    }

    public void setID(String value) {
        this.m_ID = value == null ? "" : value;
    }

    public String getID() {
        return this.m_ID;
    }

    public boolean hasID() {
        return this.m_ID.length() > 0;
    }

    @Override
    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        int result = 0;
        if (!(o instanceof XYSequencePoint)) {
            return -1;
        }
        XYSequencePoint other = (XYSequencePoint)o;
        result = this.getID().compareTo(other.getID());
        if (result == 0) {
            result = ((Comparable)this.getX()).compareTo(other.getX());
        }
        if (result == 0) {
            result = ((Comparable)this.getY()).compareTo(other.getY());
        }
        return result;
    }

    @Override
    public void assign(DataPoint other) {
        super.assign(other);
        XYSequencePoint point = (XYSequencePoint)other;
        this.setX(point.getX());
        this.setY(point.getY());
    }

    public XYSequencePoint parse(String s) {
        XYSequencePoint<Double, Double> result = null;
        String[] parts = s.split(",");
        if (parts.length == 3) {
            result = new XYSequencePoint<Double, Double>(parts[0], Double.parseDouble(parts[1]), Double.parseDouble(parts[2]));
        }
        return result;
    }

    @Override
    public String toString() {
        return Utils.quote(this.getID()) + "," + this.getX() + "," + this.getY();
    }
}

