/*
 * Decompiled with CFR 0.152.
 */
package adams.data.statistics;

import adams.data.statistics.AbstractArrayStatistic;
import adams.data.statistics.StatUtils;

public class ArrayMean<T extends Number>
extends AbstractArrayStatistic<T> {
    private static final long serialVersionUID = 2709053592980198346L;

    @Override
    public String globalInfo() {
        return "Calculates the mean for a numeric array.";
    }

    @Override
    public int getMin() {
        return 1;
    }

    @Override
    public int getMax() {
        return -1;
    }

    @Override
    protected AbstractArrayStatistic.StatisticContainer doCalculate() {
        AbstractArrayStatistic.StatisticContainer<Double> result = new AbstractArrayStatistic.StatisticContainer<Double>(1, this.size());
        for (int i = 0; i < this.size(); ++i) {
            if (this.size() > 1) {
                result.setHeader(i, "mean-" + (i + 1));
            } else {
                result.setHeader(i, "mean");
            }
            result.setCell(0, i, StatUtils.mean((Number[])this.get(i)));
        }
        return result;
    }
}

