/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.DateFormat;
import adams.gui.core.CheckedTextField;
import java.util.Date;
import javax.swing.text.Document;

public class DateTextField
extends CheckedTextField {
    private static final long serialVersionUID = 662410175911423633L;

    public DateTextField(String format) {
        super(new DateCheckModel(format));
    }

    public DateTextField(String format, String text) {
        super(text, (CheckedTextField.AbstractCheckModel)new DateCheckModel(format));
    }

    public DateTextField(String format, int columns) {
        super(columns, (CheckedTextField.AbstractCheckModel)new DateCheckModel(format));
    }

    public DateTextField(String format, String text, int columns) {
        super(text, columns, new DateCheckModel(format));
    }

    public DateTextField(String format, Document doc, String text, int columns) {
        super(doc, text, columns, new DateCheckModel(format));
    }

    @Override
    protected CheckedTextField.AbstractCheckModel getDefaultCheckModel() {
        return new DateCheckModel();
    }

    @Override
    public void setCheckModel(CheckedTextField.AbstractCheckModel value) {
        if (!(value instanceof DateCheckModel)) {
            throw new IllegalArgumentException("Only " + DateCheckModel.class.getName() + " models are allowed!");
        }
        super.setCheckModel(value);
    }

    public static class DateCheckModel
    extends CheckedTextField.AbstractCheckModel {
        private static final long serialVersionUID = -2579549735806129821L;
        protected String m_Format;
        protected transient DateFormat m_DateFormat;

        public DateCheckModel() {
            this("yyyy-MM-dd'T'HH:mm:ss");
        }

        public DateCheckModel(String format) {
            this(format, new Date());
        }

        public DateCheckModel(String format, Date defValue) {
            this.m_Format = format;
            this.m_DefaultValue = this.getDateFormat().format(defValue);
        }

        protected synchronized DateFormat getDateFormat() {
            if (this.m_DateFormat == null) {
                this.m_DateFormat = new DateFormat(this.m_Format);
            }
            return this.m_DateFormat;
        }

        @Override
        public boolean isValid(String text) {
            boolean result;
            try {
                this.getDateFormat().parse(text);
                result = true;
            }
            catch (Exception e) {
                result = false;
            }
            return result;
        }

        public String getFormat() {
            return this.m_Format;
        }

        @Override
        public String toString() {
            return super.toString() + ", format=" + this.m_Format;
        }
    }
}

