/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.Properties;
import adams.core.Utils;
import adams.core.management.OS;
import adams.env.Environment;
import adams.gui.application.Child;
import adams.gui.core.TransferableImage;
import adams.gui.core.TransferableString;
import adams.gui.dialog.TextDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class GUIHelper {
    public static final String FILENAME = "GUIHelper.props";
    public static final String EMPTY_ICON = "empty.gif";
    public static final char MNEMONIC_INDICATOR = '_';
    protected static Properties m_Properties;
    protected static Rectangle m_ScreenBoundaries;

    protected static synchronized void initializeProperties() {
        if (m_Properties == null) {
            m_Properties = Environment.getInstance().read("gui helper");
        }
    }

    public static boolean hasImageFile(String name) {
        return GUIHelper.getImageFilename(name) != null;
    }

    public static String getImageFilename(String name) {
        String result = null;
        String[] dirs = GUIHelper.getString("ImagesDirectory", "adams/gui/images/").split(",");
        for (int i = 0; i < dirs.length; ++i) {
            if (!dirs[i].endsWith("/")) {
                int n = i;
                dirs[n] = dirs[n] + "/";
            }
            try {
                URL url = ClassLoader.getSystemClassLoader().getResource(dirs[i] + name);
                if (url == null) continue;
                result = dirs[i] + name;
                break;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public static ImageIcon getIcon(Class cls) {
        if (GUIHelper.hasImageFile(cls.getName() + ".gif")) {
            return GUIHelper.getIcon(cls.getName() + ".gif");
        }
        if (GUIHelper.hasImageFile(cls.getName() + ".png")) {
            return GUIHelper.getIcon(cls.getName() + ".png");
        }
        if (GUIHelper.hasImageFile(cls.getName() + ".jpg")) {
            return GUIHelper.getIcon(cls.getName() + ".jpg");
        }
        return null;
    }

    public static ImageIcon getIcon(String name) {
        String filename = GUIHelper.getImageFilename(name);
        if (filename != null) {
            return new ImageIcon(ClassLoader.getSystemClassLoader().getResource(filename));
        }
        return null;
    }

    public static ImageIcon getExternalIcon(String filename) {
        ImageIcon result;
        try {
            result = new ImageIcon(ClassLoader.getSystemClassLoader().getResource(filename));
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public static ImageIcon getEmptyIcon() {
        return GUIHelper.getIcon(EMPTY_ICON);
    }

    public static ImageIcon getLogoImage() {
        ImageIcon result = null;
        String filename = GUIHelper.getString("LogoImage", "");
        if (filename.length() != 0) {
            result = GUIHelper.getIcon(filename);
        }
        return result;
    }

    public static ImageIcon getLogoIcon() {
        ImageIcon result = null;
        String filename = GUIHelper.getString("LogoIcon", "");
        if (filename.length() != 0) {
            result = GUIHelper.getIcon(filename);
        }
        return result;
    }

    public static void setSize(Window window, Component c) {
        GUIHelper.initializeProperties();
        if (c != null) {
            int height;
            int width;
            if (m_Properties.getBoolean(c.getClass().getName() + ".pack", false).booleanValue()) {
                window.pack();
            }
            if ((width = m_Properties.getInteger(c.getClass().getName() + ".width", window.getWidth()).intValue()) == -1) {
                width = window.getGraphicsConfiguration().getBounds().width;
            }
            if ((height = m_Properties.getInteger(c.getClass().getName() + ".height", window.getHeight()).intValue()) == -1) {
                height = window.getGraphicsConfiguration().getBounds().height;
            }
            window.setSize(width, height);
            window.validate();
        }
    }

    public static void setSizeAndLocation(Window window) {
        GUIHelper.setSizeAndLocation(window, null);
    }

    public static void setSizeAndLocation(Window window, Component c) {
        int top;
        int left;
        GUIHelper.initializeProperties();
        GUIHelper.setSize(window, c);
        if (c != null) {
            left = m_Properties.getInteger(c.getClass().getName() + ".left", window.getX());
            if (left == -1) {
                left = (window.getGraphicsConfiguration().getBounds().width - window.getWidth()) / 2;
            } else if (left == -2) {
                left = window.getGraphicsConfiguration().getBounds().width - left;
            }
            if (left < 0) {
                left = 0;
            }
        } else {
            left = 0;
        }
        if (c != null) {
            top = m_Properties.getInteger(c.getClass().getName() + ".top", window.getY());
            if (top == -1) {
                top = (window.getGraphicsConfiguration().getBounds().height - window.getHeight()) / 2;
            } else if (top == -2) {
                top = window.getGraphicsConfiguration().getBounds().height - top;
            }
            if (top < 0) {
                top = 0;
            }
        } else {
            top = 0;
        }
        GUIHelper.setSizeAndLocation(window, top, left, c);
    }

    public static void setSizeAndLocation(Window window, int top, int left) {
        GUIHelper.setSizeAndLocation(window, top, left, null);
    }

    public static void setSizeAndLocation(Window window, int top, int left, Component c) {
        GUIHelper.initializeProperties();
        GUIHelper.setSize(window, c);
        GUIHelper.adjustSize(window);
        int height = window.getHeight();
        int width = window.getWidth();
        Rectangle screen = GUIHelper.getScreenBounds(window);
        if (left + width > screen.width) {
            left = screen.width - width;
        }
        if (top + height > screen.height) {
            top = screen.height - height;
        }
        window.setLocation(left, top);
    }

    public static synchronized Rectangle getScreenBounds(Window window) {
        if (m_ScreenBoundaries == null) {
            GUIHelper.initializeProperties();
            int top = m_Properties.getInteger("ScreenBorder.Top", 0);
            int left = m_Properties.getInteger("ScreenBorder.Left", 0);
            int bottom = m_Properties.getInteger("ScreenBorder.Bottom", 0);
            int right = m_Properties.getInteger("ScreenBorder.Right", 0);
            int height = window.getGraphicsConfiguration().getBounds().height - top - bottom;
            int width = window.getGraphicsConfiguration().getBounds().width - left - right;
            m_ScreenBoundaries = new Rectangle(left, top, width, height);
        }
        return m_ScreenBoundaries;
    }

    public static void adjustSize(Window window) {
        double percWidth;
        Rectangle screen = GUIHelper.getScreenBounds(window);
        int height = window.getHeight();
        int width = window.getWidth();
        double percHeight = m_Properties.getDouble("MaxWindowHeight", 0.95);
        if (percHeight <= 0.0 || percHeight > 1.0) {
            percHeight = 0.95;
        }
        if ((percWidth = m_Properties.getDouble("MaxWindowWidth", 0.95).doubleValue()) <= 0.0 || percWidth > 1.0) {
            percWidth = 0.95;
        }
        if ((double)height > (double)screen.height * percHeight) {
            height = (int)((double)screen.height * percHeight);
        }
        if ((double)width > (double)screen.width * percWidth) {
            width = (int)((double)screen.width * percWidth);
        }
        window.setSize(width, height);
        window.validate();
    }

    public static File getStartupScript(Component c) {
        String script;
        GUIHelper.initializeProperties();
        File result = null;
        String key = c.getClass().getName() + ".script";
        if (m_Properties.hasKey(key) && !(result = new File(script = m_Properties.getString(key))).exists()) {
            System.err.println("Startup script '" + script + "' listed for component '" + c.getClass().getName() + "' does not exist - ignored!");
            result = null;
        }
        return result;
    }

    public static String getString(String key, String defValue) {
        GUIHelper.initializeProperties();
        return m_Properties.getProperty(key, defValue);
    }

    public static String getString(Class cls, String key, String defValue) {
        return GUIHelper.getString(cls.getName() + "." + key, defValue);
    }

    public static Integer getInteger(String key, Integer defValue) {
        GUIHelper.initializeProperties();
        return m_Properties.getInteger(key, defValue);
    }

    public static Integer getInteger(Class cls, String key, Integer defValue) {
        return GUIHelper.getInteger(cls.getName() + "." + key, defValue);
    }

    public static Color getColor(String key, Color defValue) {
        GUIHelper.initializeProperties();
        return m_Properties.getColor(key, defValue);
    }

    public static Color getColor(Class cls, String key, Color defValue) {
        return GUIHelper.getColor(cls.getName() + "." + key, defValue);
    }

    public static Double getDouble(String key, Double defValue) {
        GUIHelper.initializeProperties();
        return m_Properties.getDouble(key, defValue);
    }

    public static Double getDouble(Class cls, String key, Double defValue) {
        return GUIHelper.getDouble(cls.getName() + "." + key, defValue);
    }

    public static Boolean getBoolean(String key, Boolean defValue) {
        GUIHelper.initializeProperties();
        return m_Properties.getBoolean(key, defValue);
    }

    public static Boolean getBoolean(Class cls, String key, Boolean defValue) {
        return GUIHelper.getBoolean(cls.getName() + "." + key, defValue);
    }

    public static Object getParent(Container cont, Class parentClass) {
        Container result = null;
        for (Container parent = cont; parent != null; parent = parent.getParent()) {
            if (!parentClass.isInstance(parent)) continue;
            result = parent;
            break;
        }
        return result;
    }

    public static Frame getParentFrame(Container cont) {
        return (Frame)GUIHelper.getParent(cont, Frame.class);
    }

    public static Dialog getParentDialog(Container cont) {
        return (Dialog)GUIHelper.getParent(cont, Dialog.class);
    }

    public static Component getParentComponent(Component comp) {
        if (!(comp instanceof Container)) {
            return null;
        }
        Container cont = (Container)comp;
        Component result = GUIHelper.getParentDialog(cont);
        if (result == null) {
            result = (Component)((Object)GUIHelper.getParentChild(cont));
        }
        if (result == null) {
            result = GUIHelper.getParentFrame(cont);
        }
        return result;
    }

    public static JInternalFrame getParentInternalFrame(Container cont) {
        return (JInternalFrame)GUIHelper.getParent(cont, JInternalFrame.class);
    }

    public static Child getParentChild(Container cont) {
        return (Child)GUIHelper.getParent(cont, Child.class);
    }

    public static void copyToClipboard(String s) {
        TransferableString selection = new TransferableString(s);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(selection, null);
    }

    public static void copyToClipboard(BufferedImage img) {
        TransferableImage selection = new TransferableImage(img);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(selection, null);
    }

    public static boolean canPasteFromClipboard() {
        boolean result;
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            result = clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public static String pasteFromClipboard() {
        String result = null;
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable content = clipboard.getContents(null);
            if (content != null && content.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                result = (String)content.getTransferData(DataFlavor.stringFlavor);
            }
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public static String pasteSetupFromClipboard() {
        String[] parts;
        StringBuilder result = new StringBuilder(GUIHelper.pasteFromClipboard());
        if (result != null && (parts = result.toString().replaceAll("\r", "").split("\n")).length > 1) {
            String line;
            int i;
            Vector<String> lines = new Vector<String>();
            for (i = 0; i < parts.length; ++i) {
                line = parts[i].trim();
                if (line.length() == 0) continue;
                lines.add(line);
            }
            boolean formatOK = true;
            for (i = 0; i < lines.size(); ++i) {
                if (i < lines.size() - 1) {
                    formatOK = ((String)lines.get(i)).endsWith("\\");
                } else {
                    boolean bl = formatOK = !((String)lines.get(i)).endsWith("\\");
                }
                if (!formatOK) break;
            }
            if (formatOK) {
                result = new StringBuilder();
                for (i = 0; i < lines.size(); ++i) {
                    if (i > 0) {
                        result.append(" ");
                    }
                    line = (String)lines.get(i);
                    if (i < lines.size() - 1) {
                        line = line.substring(0, ((String)lines.get(i)).length() - 1).trim();
                    }
                    result.append(line);
                }
            }
        }
        return result.toString();
    }

    public static String getLookAndFeel() {
        return GUIHelper.getString("LookAndFeel", UIManager.getCrossPlatformLookAndFeelClassName());
    }

    public static boolean setLookAndFeel(String classname) {
        boolean result;
        try {
            UIManager.setLookAndFeel(classname);
            result = true;
        }
        catch (Exception e) {
            result = false;
            System.err.println("Can't set look & feel:" + e);
        }
        return result;
    }

    public static char[] getMnemonics(String[] labels) {
        char ch;
        int i;
        char[] result = new char[labels.length];
        String allowed = "abdefghijklnpqrstuvwxyz0123456789";
        String[] strLabels = new String[labels.length];
        int numLabels = 0;
        for (i = 0; i < labels.length; ++i) {
            strLabels[i] = labels[i].toLowerCase().replaceAll("[^a-z0-9]", "");
            if (strLabels[i].length() == 0) {
                strLabels[i] = null;
                continue;
            }
            ++numLabels;
        }
        Hashtable charIndices = new Hashtable();
        for (i = 0; i < allowed.length(); ++i) {
            ch = allowed.charAt(i);
            for (int n = 0; n < strLabels.length; ++n) {
                if (strLabels[n] == null || strLabels[n].indexOf(ch) <= -1) continue;
                if (!charIndices.containsKey(Character.valueOf(ch))) {
                    charIndices.put(Character.valueOf(ch), new HashSet());
                }
                ((HashSet)charIndices.get(Character.valueOf(ch))).add(n);
            }
        }
        i = 0;
        HashSet processedIndices = new HashSet();
        do {
            ++i;
            Enumeration enm = charIndices.keys();
            while (enm.hasMoreElements()) {
                ch = ((Character)enm.nextElement()).charValue();
                if (((HashSet)charIndices.get(Character.valueOf(ch))).size() != i) continue;
                for (Integer index : (HashSet)charIndices.get(Character.valueOf(ch))) {
                    if (index < 0 || strLabels[index] == null) continue;
                    result[index.intValue()] = ch;
                    strLabels[index.intValue()] = null;
                }
                processedIndices.addAll((Collection)charIndices.get(Character.valueOf(ch)));
                processedIndices.remove(-1);
            }
        } while (processedIndices.size() != numLabels);
        return result;
    }

    public static boolean hasMnemonic(String caption) {
        return caption.indexOf(95) > -1;
    }

    public static char getMnemonic(String caption) {
        int pos = caption.indexOf(95);
        if (pos > -1 && pos < caption.length() - 1) {
            return caption.charAt(pos + 1);
        }
        return '\u0000';
    }

    public static String stripMnemonic(String caption) {
        return caption.replace("_", "");
    }

    public static void showErrorMessage(Component parent, String msg) {
        GUIHelper.showErrorMessage(parent, msg, "Error");
    }

    public static void showErrorMessage(Component parent, String msg, String title) {
        String[] lines = msg.split("\n");
        int height = Math.min(350, (lines.length + 1) * 20);
        final TextDialog dlg = parent instanceof Frame ? new TextDialog((Frame)parent, title, true) : (parent instanceof Dialog ? new TextDialog((Dialog)parent, title, Dialog.ModalityType.DOCUMENT_MODAL) : new TextDialog((Dialog)null, title, Dialog.ModalityType.DOCUMENT_MODAL));
        dlg.setDefaultCloseOperation(2);
        dlg.setIconImage(GUIHelper.getIcon("stop.gif").getImage());
        dlg.setEditable(false);
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        dlg.getContentPane().add((Component)panelButtons, "South");
        JButton buttonOK = new JButton("Close");
        buttonOK.setMnemonic('l');
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dlg.setVisible(false);
                dlg.dispose();
            }
        });
        panelButtons.add(buttonOK);
        dlg.pack();
        dlg.setSize(600, dlg.getHeight() + height);
        dlg.setLocationRelativeTo(null);
        dlg.setContent(msg);
        dlg.setVisible(true);
    }

    public static void showInformationMessage(Component parent, String msg) {
        GUIHelper.showInformationMessage(parent, msg, "Information");
    }

    public static void showInformationMessage(Component parent, String msg, String title) {
        JOptionPane.showMessageDialog(parent, msg, title, 1);
    }

    public static String processTipText(String text, int width) {
        String result = text;
        if (result.length() > width) {
            String[] lines = Utils.breakUp(result, width);
            result = Utils.flatten(lines, "<br>");
        }
        result = "<html>" + result + "</html>";
        return result;
    }

    public static String processKeyStroke(String keystroke) {
        String result = keystroke;
        if (OS.isMac() && (result = result.replace("ctrl", "meta").replace("control", "meta")).indexOf("meta") == -1 && result.indexOf("alt") == -1) {
            result = "meta " + result;
        }
        return result;
    }

    public static KeyStroke getKeyStroke(String keystroke) {
        return KeyStroke.getKeyStroke(GUIHelper.processKeyStroke(keystroke));
    }
}

