/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.report.reportfactory;

import adams.core.Utils;
import adams.data.report.AbstractField;
import adams.data.report.Report;
import adams.db.ReportProvider;
import adams.gui.action.AbstractBaseAction;
import adams.gui.chooser.AbstractReportFileChooser;
import adams.gui.core.GUIHelper;
import adams.gui.visualization.report.ReportFactory;
import adams.gui.visualization.report.reportfactory.MultiSelectionTableAction;
import adams.gui.visualization.report.reportfactory.Separator;
import javax.swing.Icon;
import javax.swing.JPopupMenu;

public abstract class AbstractTableAction
extends AbstractBaseAction {
    private static final long serialVersionUID = 3352294109225825118L;
    public static final String SEPARATOR = "-";
    public static final String KEY_TABLE = "table";
    public static final String KEY_ROWS = "rows";
    public static final String KEY_FIELDS = "fields";
    public static final String KEY_VALUES = "values";

    public AbstractTableAction() {
    }

    public AbstractTableAction(String name) {
        super(name);
    }

    public AbstractTableAction(String name, Icon icon) {
        super(name, icon);
    }

    public AbstractTableAction(String name, String icon) {
        super(name, icon);
    }

    protected void setTable(ReportFactory.Table value) {
        this.putValue(KEY_TABLE, value);
    }

    protected ReportFactory.Table getTable() {
        return (ReportFactory.Table)this.getValue(KEY_TABLE);
    }

    protected void setRows(int[] value) {
        this.putValue(KEY_ROWS, value);
    }

    protected int[] getRow() {
        return (int[])this.getValue(KEY_ROWS);
    }

    protected void setFields(AbstractField[] value) {
        this.putValue(KEY_FIELDS, value);
    }

    protected AbstractField[] getFields() {
        return (AbstractField[])this.getValue(KEY_FIELDS);
    }

    protected void setValues(String[] value) {
        this.putValue(KEY_VALUES, value);
    }

    protected String[] getValues() {
        return (String[])this.getValue(KEY_VALUES);
    }

    protected ReportProvider getReportProvider() {
        if (this.getTable() != null) {
            return this.getTable().getReportProvider();
        }
        return null;
    }

    protected void setReport(Report value) {
        if (this.getTable() != null) {
            this.getTable().setReport(value);
        }
    }

    protected Report getReport() {
        if (this.getTable() != null) {
            return this.getTable().getReport();
        }
        return null;
    }

    protected AbstractReportFileChooser getFileChooser() {
        if (this.getTable() != null) {
            return this.getTable().getFileChooser();
        }
        return null;
    }

    protected Double parseDouble(String s) {
        Double result;
        try {
            result = Double.parseDouble(s);
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
            GUIHelper.showErrorMessage(this.getTable(), "Error parsing value '" + s + "':\n" + e);
        }
        return result;
    }

    protected Boolean parseBoolean(String s) {
        Boolean result;
        try {
            result = Boolean.parseBoolean(s);
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
            GUIHelper.showErrorMessage(this.getTable(), "Error parsing value '" + s + "':\n" + e);
        }
        return result;
    }

    public abstract boolean isApplicable(ReportFactory.Table var1, int var2, AbstractField var3, String var4);

    public static JPopupMenu createPopup(String[] actions2, ReportFactory.Table table, int[] rows) {
        JPopupMenu result = new JPopupMenu();
        AbstractField[] fields = new AbstractField[rows.length];
        Object[] values = new Object[rows.length];
        String[] valuesStr = new String[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            fields[i] = table.getFieldAt(rows[i]);
            values[i] = table.getValueAt(rows[i], 2);
            valuesStr[i] = values[i] == null ? "" : "" + values[i];
        }
        boolean wasSeparator = true;
        for (String action : actions2) {
            if (action.equals(SEPARATOR) || action.equals(Separator.class.getName())) {
                if (wasSeparator) continue;
                result.addSeparator();
                wasSeparator = true;
                continue;
            }
            try {
                boolean multiAppl;
                AbstractTableAction taction = (AbstractTableAction)Class.forName(action).newInstance();
                boolean singleAppl = rows.length == 1 && taction.isApplicable(table, rows[0], fields[0], valuesStr[0]);
                boolean bl = multiAppl = rows.length > 0 && taction instanceof MultiSelectionTableAction && ((MultiSelectionTableAction)((Object)taction)).isApplicable(table, rows, fields, valuesStr);
                if (!singleAppl && !multiAppl) continue;
                taction.setTable(table);
                taction.setRows(rows);
                taction.setFields(fields);
                taction.setValues(valuesStr);
                wasSeparator = false;
                result.add(taction);
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate table action '" + action + "':");
                e.printStackTrace();
            }
        }
        return result;
    }

    public static String createName(String prefix, AbstractField[] fields, int limit) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < fields.length; ++i) {
            if (i > 0) {
                str.append(", ");
            }
            str.append("'" + fields[i].toDisplayString() + "'");
        }
        return prefix + (fields.length != 1 ? "s" : "") + " " + Utils.shorten(str.toString(), limit);
    }
}

