/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.filter;

import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.filter.PNGAveragePrediction;
import de.intarsys.pdf.filter.PNGNonePrediction;
import de.intarsys.pdf.filter.PNGPaethPrediction;
import de.intarsys.pdf.filter.PNGPrediction;
import de.intarsys.pdf.filter.PNGSubPrediction;
import de.intarsys.pdf.filter.PNGUpPrediction;
import java.io.IOException;

public class PNGOptimumPrediction
extends PNGPrediction {
    private PNGPrediction average;
    private PNGPrediction none;
    private PNGPrediction paeth;
    private PNGPrediction sub;
    private PNGPrediction up;

    public PNGOptimumPrediction(COSDictionary options) {
        super(options);
        this.none = new PNGNonePrediction(options);
        this.sub = new PNGSubPrediction(options);
        this.up = new PNGUpPrediction(options);
        this.average = new PNGAveragePrediction(options);
        this.paeth = new PNGPaethPrediction(options);
    }

    public void decodeRow(byte[] source, int sourceOffset, byte[] result, int resultOffset) throws IOException {
        PNGPrediction prediction;
        switch (source[sourceOffset] + 10) {
            case 10: {
                prediction = this.none;
                break;
            }
            case 11: {
                prediction = this.sub;
                break;
            }
            case 12: {
                prediction = this.up;
                break;
            }
            case 13: {
                prediction = this.average;
                break;
            }
            case 14: {
                prediction = this.paeth;
                break;
            }
            default: {
                throw new IOException("Unknown predictor function.");
            }
        }
        prediction.decodeRow(source, sourceOffset, result, resultOffset);
    }
}

