/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.util.Arrays;
import weka.core.Optimization;
import weka.core.RevisionHandler;
import weka.core.TechnicalInformation;

public abstract class ConjugateGradientOptimization
extends Optimization
implements RevisionHandler {
    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Y.H. Dai and Y. Yuan");
        result.setValue(TechnicalInformation.Field.YEAR, "2001");
        result.setValue(TechnicalInformation.Field.TITLE, "An Efficient Hybrid Conjugate Gradient Method for Unconstrained Optimization");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Annals of Operations Research");
        result.setValue(TechnicalInformation.Field.VOLUME, "103");
        result.setValue(TechnicalInformation.Field.PAGES, "33-47");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "W.W. Hager and H. Zhang");
        result.setValue(TechnicalInformation.Field.YEAR, "2006");
        result.setValue(TechnicalInformation.Field.TITLE, "A survey of nonlinear conjugate gradient methods");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Pacific Journal of Optimization");
        result.setValue(TechnicalInformation.Field.VOLUME, "2");
        result.setValue(TechnicalInformation.Field.PAGES, "35-58");
        return result;
    }

    public ConjugateGradientOptimization() {
        this.setMaxIteration(2000);
        this.m_BETA = 0.1;
    }

    @Override
    public double[] findArgmin(double[] initX, double[][] constraints) throws Exception {
        int l = initX.length;
        this.m_f = this.objectiveFunction(initX);
        if (Double.isNaN(this.m_f)) {
            throw new Exception("Objective function value is NaN!");
        }
        double[] grad = this.evaluateGradient(initX);
        double[] deltaGrad = new double[l];
        double[] deltaX = new double[l];
        double[] direct = new double[l];
        double[] x = new double[l];
        double sum = 0.0;
        for (int i = 0; i < grad.length; ++i) {
            direct[i] = -grad[i];
            sum += grad[i] * grad[i];
        }
        double stpmax = this.m_STPMX * Math.max(Math.sqrt(sum), (double)l);
        boolean[] isFixed = new boolean[initX.length];
        Optimization.DynamicIntArray wsBdsIndx = new Optimization.DynamicIntArray(this, initX.length);
        double[][] consts = new double[2][initX.length];
        for (int i = 0; i < initX.length; ++i) {
            if (!Double.isNaN(constraints[0][i]) || !Double.isNaN(constraints[1][i])) {
                throw new Exception("Cannot deal with constraints, sorry.");
            }
            consts[0][i] = constraints[0][i];
            consts[1][i] = constraints[1][i];
            x[i] = initX[i];
        }
        boolean finished = false;
        for (int step = 0; step < this.m_MAXITS; ++step) {
            double tmp;
            if (m_Debug) {
                System.err.println("\nIteration # " + step + ":");
            }
            double[] oldX = x;
            double[] oldGrad = grad;
            double[] directB = Arrays.copyOf(direct, direct.length);
            this.m_IsZeroStep = false;
            x = this.lnsrch(x, grad, directB, stpmax, isFixed, constraints, wsBdsIndx);
            if (this.m_IsZeroStep) {
                throw new Exception("Exiting due to zero step.");
            }
            boolean finish = false;
            double test = 0.0;
            for (int h = 0; h < x.length; ++h) {
                deltaX[h] = x[h] - oldX[h];
                tmp = Math.abs(deltaX[h]) / Math.max(Math.abs(x[h]), 1.0);
                if (!(tmp > test)) continue;
                test = tmp;
            }
            if (test < m_Zero) {
                if (m_Debug) {
                    System.err.println("\nDeltaX converged: " + test);
                }
                finished = true;
                break;
            }
            grad = this.evaluateGradient(x);
            test = 0.0;
            for (int g = 0; g < l; ++g) {
                tmp = Math.abs(grad[g]) * Math.max(Math.abs(directB[g]), 1.0) / Math.max(Math.abs(this.m_f), 1.0);
                if (!(tmp > test)) continue;
                test = tmp;
            }
            if (test < m_Zero) {
                if (m_Debug) {
                    for (int i = 0; i < l; ++i) {
                        System.out.println(grad[i] + " " + directB[i] + " " + this.m_f);
                    }
                    System.err.println("Gradient converged: " + test);
                }
                finished = true;
                break;
            }
            double betaHSNumerator = 0.0;
            double betaDYNumerator = 0.0;
            double betaHSandDYDenominator = 0.0;
            for (int i = 0; i < grad.length; ++i) {
                betaDYNumerator += grad[i] * grad[i];
                betaHSNumerator += (grad[i] - oldGrad[i]) * grad[i];
                betaHSandDYDenominator += (grad[i] - oldGrad[i]) * direct[i];
            }
            double betaHS = betaHSNumerator / betaHSandDYDenominator;
            double betaDY = betaDYNumerator / betaHSandDYDenominator;
            if (m_Debug) {
                System.err.println("Beta HS: " + betaHS);
                System.err.println("Beta DY: " + betaDY);
            }
            for (int i = 0; i < direct.length; ++i) {
                direct[i] = -grad[i] + Math.max(0.0, Math.min(betaHS, betaDY)) * direct[i];
            }
        }
        if (finished) {
            if (m_Debug) {
                System.err.println("Minimum found.");
            }
            this.m_f = this.objectiveFunction(x);
            if (Double.isNaN(this.m_f)) {
                throw new Exception("Objective function value is NaN!");
            }
            return x;
        }
        if (m_Debug) {
            System.err.println("Cannot find minimum -- too many iterations!");
        }
        this.m_X = x;
        return null;
    }
}

