/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.type;

import de.intarsys.nativec.api.NativeInterface;
import de.intarsys.nativec.type.NativeType;

public class NativeAbstractStringType
extends NativeType {
    private final int characterSize;
    private final int stringSize;

    protected NativeAbstractStringType(int pCharacterSize) {
        this.characterSize = pCharacterSize;
        this.stringSize = 0;
    }

    protected NativeAbstractStringType(int pStringSize, int pCharacterSize) {
        this.characterSize = pCharacterSize;
        this.stringSize = pStringSize;
    }

    public int getByteCount() {
        if (this.stringSize == 0) {
            throw new IllegalStateException();
        }
        return this.stringSize * this.characterSize;
    }

    public int getPreferredBoundary() {
        return NativeInterface.get().pointerSize();
    }

    public int getStringSize() {
        return this.stringSize;
    }

    public boolean hasByteCount() {
        return this.stringSize != 0;
    }
}

