/*
 * Decompiled with CFR 0.152.
 */
package JSci.awt;

import JSci.awt.CategoryGraph2D;
import JSci.awt.Graph2D;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;

public final class GraphLayout
implements LayoutManager2 {
    public static final String TITLE = "Title";
    public static final String GRAPH = "Graph";
    public static final String X_AXIS = "X-axis";
    public static final String Y_AXIS = "Y-axis";
    private Component title;
    private Component graph;
    private Component xaxis;
    private Component yaxis;

    public void addLayoutComponent(String string, Component component) {
        if (TITLE.equals(string)) {
            this.title = component;
        } else if (GRAPH.equals(string) || string == null) {
            this.graph = component;
        } else if (X_AXIS.equals(string)) {
            this.xaxis = component;
        } else if (Y_AXIS.equals(string)) {
            this.yaxis = component;
        }
    }

    public void addLayoutComponent(Component component, Object object) {
        String string = object != null ? object.toString() : null;
        this.addLayoutComponent(string, component);
    }

    public void removeLayoutComponent(Component component) {
        if (component == this.title) {
            this.title = null;
        }
        if (component == this.graph) {
            this.graph = null;
        }
        if (component == this.xaxis) {
            this.xaxis = null;
        }
        if (component == this.yaxis) {
            this.yaxis = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n;
            Dimension dimension = container.getSize();
            Insets insets = container.getInsets();
            int n2 = dimension.width - insets.left - insets.right;
            int n3 = dimension.height - insets.top - insets.bottom;
            int n4 = 0;
            int n5 = 0;
            if (this.graph instanceof Graph2D) {
                n4 = ((Graph2D)this.graph).leftAxisPad;
                ((Graph2D)this.graph).getClass();
                n5 = 25;
            } else if (this.graph instanceof CategoryGraph2D) {
                n4 = ((CategoryGraph2D)this.graph).leftAxisPad;
                ((CategoryGraph2D)this.graph).getClass();
                n5 = 25;
            }
            int n6 = GraphLayout.getMinimumSize((Component)this.yaxis).width;
            int n7 = n2 - n6;
            int n8 = n = n7 - n4 - n5;
            int n9 = GraphLayout.getMinimumSize((Component)this.title).height;
            int n10 = GraphLayout.getMinimumSize((Component)this.xaxis).height;
            int n11 = n3 - n9 - n10;
            int n12 = n11 - 2 * n5;
            if (this.title != null) {
                this.title.setBounds(insets.left + n6 + n4, insets.top, n, n9);
            }
            if (this.graph != null) {
                this.graph.setBounds(insets.left + n6, insets.top + n9, n7, n11);
            }
            if (this.yaxis != null) {
                this.yaxis.setBounds(insets.left, insets.top + n9 + n5, n6, n12);
            }
            if (this.xaxis != null) {
                this.xaxis.setBounds(insets.left + n6 + n4, n3 - n10, n8, n10);
            }
        }
    }

    public void invalidateLayout(Container container) {
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public Dimension minimumLayoutSize(Container container) {
        return GraphLayout.calculateLayoutSize(container.getInsets(), GraphLayout.getMinimumSize(this.title), GraphLayout.getMinimumSize(this.graph), GraphLayout.getMinimumSize(this.xaxis), GraphLayout.getMinimumSize(this.yaxis));
    }

    private static Dimension getMinimumSize(Component component) {
        if (component == null) {
            return new Dimension();
        }
        return component.getMinimumSize();
    }

    public Dimension preferredLayoutSize(Container container) {
        return GraphLayout.calculateLayoutSize(container.getInsets(), GraphLayout.getMinimumSize(this.title), GraphLayout.getPreferredSize(this.graph), GraphLayout.getMinimumSize(this.xaxis), GraphLayout.getMinimumSize(this.yaxis));
    }

    private static Dimension getPreferredSize(Component component) {
        if (component == null) {
            return new Dimension();
        }
        return component.getPreferredSize();
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    private static Dimension calculateLayoutSize(Insets insets, Dimension dimension, Dimension dimension2, Dimension dimension3, Dimension dimension4) {
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        n2 += dimension.height + dimension3.height;
        return new Dimension(n += Math.max(dimension.width, dimension4.width + dimension2.width), n2 += Math.max(dimension4.height, dimension2.height));
    }
}

