/*
 * Decompiled with CFR 0.152.
 */
package JSci.instruments;

import JSci.instruments.Control;
import JSci.instruments.Image;
import JSci.instruments.PositionControl;
import JSci.swing.JPointer;
import JSci.swing.JSliderPlus;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PTCroquetteCross
extends Polygon
implements Control {
    private int crossHW = 3;
    private int crossL = 32;
    private Point2D position = new Point2D.Double();
    private Point intPosition = new Point();
    private double z = 0.0;
    private boolean dragging = true;
    private Rectangle bbox = null;
    private Color color;
    private CComponent component = new CComponent();
    private double[] calibration = null;
    private boolean calibrating = true;
    private int zNum;
    private int zLevel = -1;
    private double minZ;
    private double maxZ;

    public PTCroquetteCross(int n, int n2, Point point, Color color) {
        super(new int[]{-n2, n2, n2, n, n, n2, n2, -n2, -n2, -n, -n, -n2}, new int[]{-n, -n, -n2, -n2, n2, n2, n, n, n2, n2, -n2, -n2}, 12);
        this.crossHW = n2;
        this.crossL = n;
        this.intPosition.setLocation(point);
        this.translate(this.intPosition.x, this.intPosition.y);
        this.position.setLocation(point);
        this.color = color;
        this.z = 0.0;
        this.dragging = false;
        this.calibrating = false;
    }

    private void FFT(double[] dArray, double[] dArray2, int n) {
        double d;
        double d2;
        int n2;
        int n3;
        int n4 = dArray.length;
        int n5 = 2;
        switch (n4) {
            case 4: {
                n5 = 2;
                break;
            }
            case 8: {
                n5 = 3;
                break;
            }
            case 16: {
                n5 = 4;
                break;
            }
            case 32: {
                n5 = 5;
                break;
            }
            case 64: {
                n5 = 6;
                break;
            }
            case 128: {
                n5 = 7;
                break;
            }
            case 256: {
                n5 = 8;
                break;
            }
            case 512: {
                n5 = 9;
                break;
            }
            case 1024: {
                n5 = 10;
                break;
            }
            case 2048: {
                n5 = 11;
            }
        }
        int n6 = n4;
        for (int i = 1; i <= n5; ++i) {
            int n7 = n6;
            n6 = n7 / 2;
            double d3 = 1.0;
            double d4 = 0.0;
            double d5 = Math.cos(Math.PI / (double)n6);
            double d6 = (double)n * Math.sin(Math.PI / (double)n6);
            for (n3 = 0; n3 < n6; ++n3) {
                for (n2 = n3; n2 < n4; n2 += n7) {
                    int n8 = n2 + n6;
                    d2 = dArray[n2] + dArray[n8];
                    d = dArray2[n2] + dArray2[n8];
                    double d7 = dArray[n2] - dArray[n8];
                    double d8 = dArray2[n2] - dArray2[n8];
                    dArray[n8] = d7 * d3 - d8 * d4;
                    dArray2[n8] = d7 * d4 + d8 * d3;
                    dArray[n2] = d2;
                    dArray2[n2] = d;
                }
                d2 = d3 * d5 - d4 * d6;
                d4 = d3 * d6 + d4 * d5;
                d3 = d2;
            }
        }
        int n9 = n4 / 2;
        int n10 = n4 - 1;
        n3 = 0;
        for (n2 = 0; n2 < n10; ++n2) {
            int n11;
            if (n2 < n3) {
                d2 = dArray[n3];
                d = dArray2[n3];
                dArray[n3] = dArray[n2];
                dArray2[n3] = dArray2[n2];
                dArray[n2] = d2;
                dArray2[n2] = d;
            }
            for (n11 = n9; n11 < n3 + 1; n11 /= 2) {
                n3 -= n11;
            }
            n3 += n11;
        }
    }

    int fromImg(byte by) {
        if (by >= 0) {
            return by;
        }
        return 256 + by;
    }

    private Point2D findJNIXY(Image image, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        double[] dArray = new double[2 * n3];
        double[] dArray2 = new double[2 * n3];
        for (n6 = 0; n6 < 2 * n3; ++n6) {
            dArray2[n6] = 0.0;
            dArray[n6] = 0.0;
        }
        for (n5 = -n4; n5 < n4; ++n5) {
            for (n6 = 0; n6 < 2 * n3; ++n6) {
                int n7 = n6;
                dArray[n7] = dArray[n7] + (double)this.fromImg(image.getData()[image.getOffset() + n - n3 + n6 + (n2 + n5) * image.getScansize()]);
            }
        }
        for (n5 = 0; n5 < 2 * n3; ++n5) {
            for (n6 = -n4; n6 < n4; ++n6) {
                int n8 = n5;
                dArray2[n8] = dArray2[n8] + (double)this.fromImg(image.getData()[image.getOffset() + n + n6 + (n2 - n3 + n5) * image.getScansize()]);
            }
        }
        this.FFT(dArray, dArray2, 1);
        n6 = 0;
        while (n6 <= n3) {
            n5 = n6 == 0 ? 0 : 2 * n3 - n6;
            double d = dArray[n6];
            double d2 = dArray2[n6];
            double d3 = dArray[n5];
            double d4 = dArray2[n5];
            dArray2[n5] = 0.0;
            dArray[n5] = 0.0;
            dArray2[n6] = 0.0;
            dArray[n6] = 0.0;
            double d5 = (d + d3) / 2.0;
            double d6 = (d2 - d4) / 2.0;
            double d7 = Math.pow(d5, 2.0) - Math.pow(d6, 2.0);
            d6 = 2.0 * d5 * d6;
            d5 = d7;
            int n9 = n6;
            dArray[n9] = dArray[n9] + d5;
            int n10 = n6;
            dArray2[n10] = dArray2[n10] + d6;
            int n11 = n5;
            dArray[n11] = dArray[n11] + d5;
            int n12 = n5;
            dArray2[n12] = dArray2[n12] + -d6;
            d5 = (d2 + d4) / 2.0;
            d6 = -(d - d3) / 2.0;
            d7 = Math.pow(d5, 2.0) - Math.pow(d6, 2.0);
            d6 = 2.0 * d5 * d6;
            d5 = d7;
            int n13 = n6;
            dArray[n13] = dArray[n13] + -d6;
            int n14 = n6++;
            dArray2[n14] = dArray2[n14] + d5;
            int n15 = n5;
            dArray[n15] = dArray[n15] + d6;
            int n16 = n5;
            dArray2[n16] = dArray2[n16] + d5;
        }
        this.FFT(dArray, dArray2, -1);
        double d = dArray[0];
        double d8 = dArray2[0];
        int n17 = 0;
        int n18 = 0;
        for (n6 = 0; n6 < 2 * n3; ++n6) {
            if (dArray[n6] > d) {
                d = dArray[n6];
                n18 = n6;
            }
            if (!(dArray2[n6] > d8)) continue;
            d8 = dArray2[n6];
            n17 = n6;
        }
        if (n18 >= n3) {
            n18 -= 2 * n3;
        }
        if (n17 >= n3) {
            n17 -= 2 * n3;
        }
        return new Point2D.Double((double)n18 / 2.0 + (double)n, (double)n17 / 2.0 + (double)n2);
    }

    private double findJNIZ(Image image, int n, int n2, int n3, int n4, int n5, double[] dArray) {
        int n6;
        int n7;
        double[] dArray2 = new double[n3];
        for (n7 = 0; n7 < n3; ++n7) {
            dArray2[n7] = 0.0;
        }
        for (n6 = -n4; n6 < n4; ++n6) {
            for (n7 = 0; n7 < n3; ++n7) {
                int n8 = n7;
                dArray2[n8] = dArray2[n8] + (double)(this.fromImg(image.getData()[image.getOffset() + n + n7 + (n2 + n6) * image.getScansize()]) + this.fromImg(image.getData()[image.getOffset() + n - n7 + (n2 + n6) * image.getScansize()]) + this.fromImg(image.getData()[image.getOffset() + n + n6 + (n2 + n7) * image.getScansize()]) + this.fromImg(image.getData()[image.getOffset() + n + n6 + (n2 - n7) * image.getScansize()]));
            }
        }
        double d = 0.0;
        for (n7 = 0; n7 < n3; ++n7) {
            d += dArray2[n7];
        }
        n7 = 0;
        while (n7 < n3) {
            int n9 = n7++;
            dArray2[n9] = dArray2[n9] / d;
        }
        double[] dArray3 = new double[n5];
        for (n6 = 0; n6 < n5; ++n6) {
            dArray3[n6] = 0.0;
            for (n7 = 0; n7 < n3; ++n7) {
                int n10 = n6;
                dArray3[n10] = dArray3[n10] + Math.pow(dArray[n6 * n3 + n7] - dArray2[n7], 2.0);
            }
        }
        d = dArray3[4];
        int n11 = 4;
        for (n6 = 0; n6 < n5; ++n6) {
            if (!(dArray3[n6] < d)) continue;
            d = dArray3[n6];
            n11 = n6;
        }
        if (n11 == 0) {
            n11 = 1;
        }
        if (n11 == n5 - 1) {
            n11 = n5 - 2;
        }
        double d2 = (dArray3[n11 + 1] - dArray3[n11 - 1]) / 2.0;
        double d3 = dArray3[n11 + 1] + dArray3[n11 - 1] - 2.0 * dArray3[n11];
        return (double)n11 - d2 / d3;
    }

    void addJNIToTemplate(Image image, int n, int n2, int n3, int n4, double[] dArray, int n5) {
        int n6;
        double[] dArray2 = new double[n3];
        for (n6 = 0; n6 < n3; ++n6) {
            dArray2[n6] = 0.0;
        }
        for (int i = -n4; i < n4; ++i) {
            for (n6 = 0; n6 < n3; ++n6) {
                int n7 = n6;
                dArray2[n7] = dArray2[n7] + (double)(this.fromImg(image.getData()[image.getOffset() + n + n6 + (n2 + i) * image.getScansize()]) + this.fromImg(image.getData()[image.getOffset() + n - n6 + (n2 + i) * image.getScansize()]) + this.fromImg(image.getData()[image.getOffset() + n + i + (n2 + n6) * image.getScansize()]) + this.fromImg(image.getData()[image.getOffset() + n + i + (n2 - n6) * image.getScansize()]));
            }
        }
        double d = 0.0;
        for (n6 = 0; n6 < n3; ++n6) {
            d += dArray2[n6];
        }
        n6 = 0;
        while (n6 < n3) {
            int n8 = n6++;
            dArray2[n8] = dArray2[n8] / d;
        }
        for (n6 = 0; n6 < n3; ++n6) {
            int n9 = n6 + n3 * n5;
            dArray[n9] = dArray[n9] + dArray2[n6];
        }
    }

    public synchronized void findXY(Image image) {
        if (this.dragging) {
            return;
        }
        this.setLocation(this.findJNIXY(image, this.intPosition.x, this.intPosition.y, this.crossL, this.crossHW));
    }

    public void findZ(Image image) {
        if (this.calibrating || this.dragging || this.calibration == null) {
            return;
        }
        this.z = this.findJNIZ(image, this.intPosition.x, this.intPosition.y, this.crossL, this.crossHW, this.zNum, this.calibration) * (this.maxZ - this.minZ) / (double)this.zNum + this.minZ;
        this.component.setValue(this.z);
    }

    public synchronized void setDragging(boolean bl) {
        this.dragging = bl;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setBBox(Rectangle rectangle) {
        this.bbox = rectangle;
    }

    public void setLocation(Point2D point2D) {
        Point point = new Point((int)point2D.getX(), (int)point2D.getY());
        if (!this.bbox.contains(this.getBounds(point))) {
            return;
        }
        this.position.setLocation(point2D);
        this.translate(-this.intPosition.x + point.x, -this.intPosition.y + point.y);
        this.intPosition.setLocation(point);
    }

    public Point2D getLocation() {
        Point2D.Double double_ = new Point2D.Double();
        double_.setLocation(this.position);
        return double_;
    }

    public double getZ() {
        return this.z;
    }

    private Rectangle getBounds(Point point) {
        return new Rectangle(point.x - this.crossL, point.y - this.crossL, 2 * this.crossL, 2 * this.crossL);
    }

    public Rectangle getBounds() {
        return this.getBounds(this.intPosition);
    }

    public Color getColor() {
        return this.color;
    }

    public Component getControlComponent() {
        return this.component;
    }

    public void calibrationStart(int n, double d, double d2) {
        this.calibrating = true;
        this.zNum = n;
        this.minZ = d;
        this.maxZ = d2;
        this.zLevel = -1;
        this.calibration = new double[n * this.crossL];
        this.component.setMinMax(d, d2);
    }

    public synchronized void calibrationSendImage(Image image) {
        if (this.zLevel < 0 || this.zLevel >= this.zNum) {
            return;
        }
        this.addJNIToTemplate(image, this.intPosition.x, this.intPosition.y, this.crossL, this.crossHW, this.calibration, this.zLevel);
        this.zLevel = -1;
        this.notify();
    }

    public synchronized void calibrationRequest(int n) {
        this.zLevel = n;
    }

    public synchronized void calibrationWait() {
        while (this.zLevel >= 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void calibrationEnd() {
        for (int i = 0; i < this.zNum; ++i) {
            int n;
            double d = 0.0;
            for (n = 0; n < this.crossL; ++n) {
                d += this.calibration[i * this.crossL + n];
            }
            for (n = 0; n < this.crossL; ++n) {
                int n2 = i * this.crossL + n;
                this.calibration[n2] = this.calibration[n2] / d;
            }
        }
        this.calibrating = false;
        this.component.updateCalibrationImageLabel();
    }

    private ImageProducer createCalibrationImage() {
        int n = this.crossL;
        int n2 = this.zNum;
        byte[] byArray = new byte[n * n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                byArray[i + j * n] = (byte)(this.calibration[i + (n2 - 1 - j) * n] * (double)this.crossL * 128.0);
            }
        }
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        byte[] byArray4 = new byte[256];
        for (int i = 0; i < 256; ++i) {
            byArray3[i] = byArray4[i] = (byte)i;
            byArray2[i] = byArray4[i];
        }
        IndexColorModel indexColorModel = new IndexColorModel(8, 256, byArray2, byArray3, byArray4);
        MemoryImageSource memoryImageSource = new MemoryImageSource(n, n2, (ColorModel)indexColorModel, byArray, 0, n);
        return memoryImageSource;
    }

    private class CComponent
    extends JPanel
    implements ChangeListener {
        JPointer sliderZero = new JPointer(5);
        JPointer sliderFound = new JPointer(4);
        JSliderPlus sliderHolder = new JSliderPlus(0, 0.0, 100.0);
        JLabel calibrImg = new JLabel();

        public CComponent() {
            this.add(this.calibrImg);
            this.sliderZero.setColor(Color.MAGENTA);
            this.sliderFound.setColor(Color.CYAN);
            this.sliderHolder.addJPointer(this.sliderZero);
            this.sliderHolder.addJPointer(this.sliderFound);
            this.add(this.sliderHolder);
            this.sliderZero.setEnabled(false);
            this.sliderFound.setEnabled(false);
        }

        public void setValue(double d) {
            this.sliderFound.setValue(d);
        }

        public void setMinMax(double d, double d2) {
            this.sliderHolder.setLimits(d, d2);
            if (Math.abs(d2 - d) < 5.0) {
                this.sliderHolder.setMinorTickSpacing(0.5);
                this.sliderHolder.setMajorTickSpacing(1.0);
            } else {
                this.sliderHolder.setMinorTickSpacing(5.0);
                this.sliderHolder.setMajorTickSpacing(10.0);
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            double d = ((PositionControl)changeEvent.getSource()).getPosition();
            this.sliderZero.setValue(d);
        }

        public void updateCalibrationImageLabel() {
            java.awt.Image image = this.calibrImg.createImage(PTCroquetteCross.this.createCalibrationImage());
            this.calibrImg.setIcon(new ImageIcon(image));
        }
    }
}

