/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.daubechies8;

import JSci.maths.wavelet.Cascades;
import JSci.maths.wavelet.IllegalScalingException;
import JSci.maths.wavelet.MultiscaleFunction;
import JSci.maths.wavelet.daubechies8.Daubechies8;

public final class Scaling8
extends MultiscaleFunction
implements Cloneable {
    private int n0;
    private int k;
    private static final Daubechies8 cdf = new Daubechies8();

    public Scaling8(int n, int n2) {
        this.setParameters(n, n2);
    }

    public String toString() {
        String string = new String("[n0=");
        string.concat(Integer.toString(this.n0));
        string.concat("][k=");
        string.concat(Integer.toString(this.k));
        string.concat("]");
        return string;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Scaling8) {
            Scaling8 scaling8 = (Scaling8)object;
            return this.dimension(0) == scaling8.dimension(0) && this.position() == scaling8.position();
        }
        return false;
    }

    public Scaling8() {
    }

    public int getFilterType() {
        return 14;
    }

    public void setParameters(int n, int n2) {
        if (n < 28) {
            throw new IllegalScalingException(n, 28);
        }
        this.n0 = n;
        this.k = n2;
    }

    public Object clone() {
        Scaling8 scaling8 = (Scaling8)super.clone();
        scaling8.n0 = this.n0;
        scaling8.k = this.k;
        return scaling8;
    }

    public double[] evaluate(int n) {
        return cdf.evalScaling(this.n0, this.k, n);
    }

    public int dimension(int n) {
        return Cascades.dimension(this.n0, n, 14);
    }

    public int dimension() {
        return this.dimension(0);
    }

    public int position() {
        return this.k;
    }
}

