/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.png;

import java.awt.Dimension;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;
import java.util.zip.InflaterInputStream;
import org.apache.sanselan.ColorTools;
import org.apache.sanselan.ImageFormat;
import org.apache.sanselan.ImageInfo;
import org.apache.sanselan.ImageParser;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.common.IImageMetadata;
import org.apache.sanselan.common.ImageMetadata;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.formats.png.GammaCorrection;
import org.apache.sanselan.formats.png.PngConstants;
import org.apache.sanselan.formats.png.PngImageInfo;
import org.apache.sanselan.formats.png.PngText;
import org.apache.sanselan.formats.png.PngWriter;
import org.apache.sanselan.formats.png.ScanExpediter;
import org.apache.sanselan.formats.png.ScanExpediterInterlaced;
import org.apache.sanselan.formats.png.ScanExpediterSimple;
import org.apache.sanselan.formats.png.chunks.PNGChunk;
import org.apache.sanselan.formats.png.chunks.PNGChunkIDAT;
import org.apache.sanselan.formats.png.chunks.PNGChunkIHDR;
import org.apache.sanselan.formats.png.chunks.PNGChunkPLTE;
import org.apache.sanselan.formats.png.chunks.PNGChunkgAMA;
import org.apache.sanselan.formats.png.chunks.PNGChunkiCCP;
import org.apache.sanselan.formats.png.chunks.PNGChunkiTXt;
import org.apache.sanselan.formats.png.chunks.PNGChunkpHYs;
import org.apache.sanselan.formats.png.chunks.PNGChunktEXt;
import org.apache.sanselan.formats.png.chunks.PNGChunkzTXt;
import org.apache.sanselan.formats.png.chunks.PNGTextChunk;
import org.apache.sanselan.formats.transparencyfilters.TransparencyFilter;
import org.apache.sanselan.formats.transparencyfilters.TransparencyFilterGrayscale;
import org.apache.sanselan.formats.transparencyfilters.TransparencyFilterIndexedColor;
import org.apache.sanselan.formats.transparencyfilters.TransparencyFilterTrueColor;
import org.apache.sanselan.icc.IccProfileParser;
import org.apache.sanselan.util.Debug;
import org.apache.sanselan.util.ParamMap;

public class PngImageParser
extends ImageParser
implements PngConstants {
    private static final String DEFAULT_EXTENSION = ".png";
    private static final String[] ACCEPTED_EXTENSIONS = new String[]{".png"};

    public String getName() {
        return "Png-Custom";
    }

    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    protected String[] getAcceptedExtensions() {
        return ACCEPTED_EXTENSIONS;
    }

    protected ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormat.IMAGE_FORMAT_PNG};
    }

    private boolean keepChunk(int ChunkType, int[] chunkTypes) {
        if (chunkTypes == null) {
            return true;
        }
        for (int i = 0; i < chunkTypes.length; ++i) {
            if (chunkTypes[i] != ChunkType) continue;
            return true;
        }
        return false;
    }

    private ArrayList readChunks(InputStream is, int[] chunkTypes, boolean returnAfterFirst) throws ImageReadException, IOException {
        int chunkType;
        ArrayList<PNGChunk> result = new ArrayList<PNGChunk>();
        do {
            if (this.debug) {
                System.out.println("");
            }
            int length = this.read4Bytes("Length", is, "Not a Valid PNG File");
            chunkType = this.read4Bytes("ChunkType", is, "Not a Valid PNG File");
            if (this.debug) {
                this.printCharQuad("ChunkType", chunkType);
                this.debugNumber("Length", length, 4);
            }
            boolean keep = this.keepChunk(chunkType, chunkTypes);
            byte[] bytes = null;
            if (keep) {
                bytes = this.readByteArray("Chunk Data", length, is, "Not a Valid PNG File: Couldn't read Chunk Data.");
            } else {
                this.skipBytes(is, length, "Not a Valid PNG File");
            }
            if (this.debug && bytes != null) {
                this.debugNumber("bytes", bytes.length, 4);
            }
            int CRC = this.read4Bytes("CRC", is, "Not a Valid PNG File");
            if (!keep) continue;
            if (chunkType == iCCP) {
                result.add(new PNGChunkiCCP(length, chunkType, CRC, bytes));
            } else if (chunkType == tEXt) {
                result.add(new PNGChunktEXt(length, chunkType, CRC, bytes));
            } else if (chunkType == zTXt) {
                result.add(new PNGChunkzTXt(length, chunkType, CRC, bytes));
            } else if (chunkType == IHDR) {
                result.add(new PNGChunkIHDR(length, chunkType, CRC, bytes));
            } else if (chunkType == PLTE) {
                result.add(new PNGChunkPLTE(length, chunkType, CRC, bytes));
            } else if (chunkType == pHYs) {
                result.add(new PNGChunkpHYs(length, chunkType, CRC, bytes));
            } else if (chunkType == IDAT) {
                result.add(new PNGChunkIDAT(length, chunkType, CRC, bytes));
            } else if (chunkType == gAMA) {
                result.add(new PNGChunkgAMA(length, chunkType, CRC, bytes));
            } else if (chunkType == iTXt) {
                result.add(new PNGChunkiTXt(length, chunkType, CRC, bytes));
            } else {
                result.add(new PNGChunk(length, chunkType, CRC, bytes));
            }
            if (!returnAfterFirst) continue;
            return result;
        } while (chunkType != IEND);
        return result;
    }

    private void readSignature(InputStream is) throws ImageReadException, IOException {
        this.readAndVerifyBytes(is, PNG_Signature, "Not a Valid PNG Segment: Incorrect Signature");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList readChunks(ByteSource byteSource, int[] chunkTypes, boolean returnAfterFirst) throws ImageReadException, IOException {
        InputStream is = null;
        try {
            is = byteSource.getInputStream();
            ArrayList chunks = null;
            this.readSignature(is);
            ArrayList arrayList = chunks = this.readChunks(is, chunkTypes, returnAfterFirst);
            return arrayList;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {
                Debug.debug(e);
            }
        }
    }

    public byte[] getICCProfileBytes(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        ArrayList chunks = this.readChunks(byteSource, new int[]{iCCP}, true);
        if (chunks == null || chunks.size() < 1) {
            return null;
        }
        if (chunks.size() > 1) {
            throw new ImageReadException("PNG contains more than one ICC Profile ");
        }
        PNGChunkiCCP pngChunkiCCP = (PNGChunkiCCP)chunks.get(0);
        byte[] bytes = pngChunkiCCP.UncompressedProfile;
        return bytes;
    }

    public Dimension getImageSize(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        ArrayList chunks = this.readChunks(byteSource, new int[]{IHDR}, true);
        if (chunks == null || chunks.size() < 1) {
            throw new ImageReadException("Png: No chunks");
        }
        if (chunks.size() > 1) {
            throw new ImageReadException("PNG contains more than one Header");
        }
        PNGChunkIHDR pngChunkIHDR = (PNGChunkIHDR)chunks.get(0);
        return new Dimension(pngChunkIHDR.width, pngChunkIHDR.height);
    }

    public byte[] embedICCProfile(byte[] image, byte[] profile) {
        return null;
    }

    public boolean embedICCProfile(File src, File dst, byte[] profile) {
        return false;
    }

    public IImageMetadata getMetadata(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        ArrayList chunks = this.readChunks(byteSource, new int[]{tEXt, zTXt}, true);
        if (chunks == null || chunks.size() < 1) {
            return null;
        }
        ImageMetadata result = new ImageMetadata();
        for (int i = 0; i < chunks.size(); ++i) {
            PNGTextChunk chunk = (PNGTextChunk)chunks.get(i);
            result.add(chunk.getKeyword(), chunk.getText());
        }
        return result;
    }

    private boolean isGrayscale(int colorType) throws ImageReadException {
        switch (colorType) {
            case 0: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
            case 4: {
                return true;
            }
            case 6: {
                return false;
            }
        }
        throw new ImageReadException("PNG: unknown color type: " + colorType);
    }

    private int samplesPerPixel(int colorType) throws ImageReadException {
        switch (colorType) {
            case 0: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 6: {
                return 4;
            }
        }
        throw new ImageReadException("PNG: unknown color type: " + colorType);
    }

    private ArrayList filterChunks(ArrayList v, int type) {
        ArrayList<PNGChunk> result = new ArrayList<PNGChunk>();
        for (int i = 0; i < v.size(); ++i) {
            PNGChunk chunk = (PNGChunk)v.get(i);
            if (chunk.chunkType != type) continue;
            result.add(chunk);
        }
        return result;
    }

    private boolean hasAlphaChannel(int ColorType) throws ImageReadException, IOException {
        switch (ColorType) {
            case 0: 
            case 2: 
            case 3: {
                return false;
            }
            case 4: 
            case 6: {
                return true;
            }
        }
        throw new ImageReadException("PNG: unknown color type: " + ColorType);
    }

    private String getColorTypeDescription(int ColorType) {
        switch (ColorType) {
            case 0: {
                return "grayscale";
            }
            case 2: {
                return "rgb";
            }
            case 3: {
                return "indexed rgb";
            }
            case 4: {
                return "grayscale w/ alpha";
            }
            case 6: {
                return "RGB w/ alpha";
            }
        }
        return "Unknown Color Type";
    }

    private TransparencyFilter getTransparencyFilter(int ColorType, PNGChunk pngChunktRNS) throws ImageReadException, IOException {
        switch (ColorType) {
            case 0: {
                return new TransparencyFilterGrayscale(pngChunktRNS.bytes);
            }
            case 2: {
                return new TransparencyFilterTrueColor(pngChunktRNS.bytes);
            }
            case 3: {
                return new TransparencyFilterIndexedColor(pngChunktRNS.bytes);
            }
        }
        throw new ImageReadException("Simple Transparency not compatible with ColorType: " + ColorType);
    }

    public ImageInfo getImageInfo(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        int ColorType;
        int i;
        ArrayList chunks = this.readChunks(byteSource, new int[]{IHDR, pHYs, tEXt, zTXt, tRNS, PLTE, iTXt}, false);
        if (chunks == null || chunks.size() < 1) {
            throw new ImageReadException("PNG: no chunks");
        }
        ArrayList IHDRs = this.filterChunks(chunks, IHDR);
        if (IHDRs.size() != 1) {
            throw new ImageReadException("PNG contains more than one Header");
        }
        PNGChunkIHDR pngChunkIHDR = (PNGChunkIHDR)IHDRs.get(0);
        PNGChunk pngChunktRNS = null;
        boolean isTransparent = false;
        ArrayList tRNSs = this.filterChunks(chunks, tRNS);
        if (tRNSs.size() > 0) {
            isTransparent = true;
            pngChunktRNS = (PNGChunk)IHDRs.get(0);
        } else {
            this.hasAlphaChannel(pngChunkIHDR.colorType);
        }
        PNGChunkpHYs pngChunkpHYs = null;
        ArrayList pHYss = this.filterChunks(chunks, pHYs);
        if (pHYss.size() > 1) {
            throw new ImageReadException("PNG contains more than one pHYs: " + pHYss.size());
        }
        if (pHYss.size() == 1) {
            pngChunkpHYs = (PNGChunkpHYs)pHYss.get(0);
        }
        ArrayList tEXts = this.filterChunks(chunks, tEXt);
        ArrayList zTXts = this.filterChunks(chunks, zTXt);
        ArrayList iTXts = this.filterChunks(chunks, iTXt);
        ArrayList<String> comments = new ArrayList<String>();
        ArrayList<PngText> textChunks = new ArrayList<PngText>();
        for (i = 0; i < tEXts.size(); ++i) {
            PNGChunktEXt pngChunktEXt = (PNGChunktEXt)tEXts.get(i);
            comments.add(pngChunktEXt.keyword + ": " + pngChunktEXt.text);
            textChunks.add(pngChunktEXt.getContents());
        }
        for (i = 0; i < zTXts.size(); ++i) {
            PNGChunkzTXt pngChunkzTXt = (PNGChunkzTXt)zTXts.get(i);
            comments.add(pngChunkzTXt.keyword + ": " + pngChunkzTXt.text);
            textChunks.add(pngChunkzTXt.getContents());
        }
        for (i = 0; i < iTXts.size(); ++i) {
            PNGChunkiTXt pngChunkiTXt = (PNGChunkiTXt)iTXts.get(i);
            comments.add(pngChunkiTXt.keyword + ": " + pngChunkiTXt.text);
            textChunks.add(pngChunkiTXt.getContents());
        }
        int BitsPerPixel = pngChunkIHDR.bitDepth * this.samplesPerPixel(pngChunkIHDR.colorType);
        ImageFormat Format2 = ImageFormat.IMAGE_FORMAT_PNG;
        String FormatName = "PNG Portable Network Graphics";
        int Height = pngChunkIHDR.height;
        String MimeType = "image/png";
        int NumberOfImages = 1;
        int Width = pngChunkIHDR.width;
        boolean isProgressive = pngChunkIHDR.interlaceMethod != 0;
        int PhysicalHeightDpi = -1;
        float PhysicalHeightInch = -1.0f;
        int PhysicalWidthDpi = -1;
        float PhysicalWidthInch = -1.0f;
        if (pngChunkpHYs != null && pngChunkpHYs.UnitSpecifier == 1) {
            double meters_per_inch = 0.0254;
            PhysicalWidthDpi = (int)Math.round((double)pngChunkpHYs.PixelsPerUnitXAxis * meters_per_inch);
            PhysicalWidthInch = (float)((double)Width * (double)pngChunkpHYs.PixelsPerUnitXAxis * meters_per_inch);
            PhysicalHeightDpi = (int)Math.round((double)pngChunkpHYs.PixelsPerUnitYAxis * meters_per_inch);
            PhysicalHeightInch = (float)((double)Height * (double)pngChunkpHYs.PixelsPerUnitYAxis * meters_per_inch);
        }
        String FormatDetails = "Png";
        boolean usesPalette = false;
        ArrayList PLTEs = this.filterChunks(chunks, PLTE);
        if (PLTEs.size() > 1) {
            usesPalette = true;
        }
        switch (pngChunkIHDR.colorType) {
            case 0: 
            case 4: {
                ColorType = 1;
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                ColorType = 2;
                break;
            }
            default: {
                throw new ImageReadException("Png: Unknown ColorType: " + pngChunkIHDR.colorType);
            }
        }
        String compressionAlgorithm = "PNG Filter";
        PngImageInfo result = new PngImageInfo(FormatDetails, BitsPerPixel, comments, Format2, FormatName, Height, MimeType, NumberOfImages, PhysicalHeightDpi, PhysicalHeightInch, PhysicalWidthDpi, PhysicalWidthInch, Width, isProgressive, isTransparent, usesPalette, ColorType, compressionAlgorithm, textChunks);
        return result;
    }

    public BufferedImage getBufferedImage(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        Boolean is_srgb;
        ScanExpediter scanExpediter;
        int bitDepth;
        ArrayList IDATs;
        ArrayList chunks;
        boolean verbose = ParamMap.getParamBoolean(params, "VERBOSE", false);
        if (params.containsKey("VERBOSE")) {
            params.remove("VERBOSE");
        }
        if ((chunks = this.readChunks(byteSource, new int[]{IHDR, PLTE, IDAT, tRNS, iCCP, gAMA, sRGB}, false)) == null || chunks.size() < 1) {
            throw new ImageReadException("PNG: no chunks");
        }
        ArrayList IHDRs = this.filterChunks(chunks, IHDR);
        if (IHDRs.size() != 1) {
            throw new ImageReadException("PNG contains more than one Header");
        }
        PNGChunkIHDR pngChunkIHDR = (PNGChunkIHDR)IHDRs.get(0);
        ArrayList PLTEs = this.filterChunks(chunks, PLTE);
        if (PLTEs.size() > 1) {
            throw new ImageReadException("PNG contains more than one Palette");
        }
        PNGChunkPLTE pngChunkPLTE = null;
        if (PLTEs.size() == 1) {
            pngChunkPLTE = (PNGChunkPLTE)PLTEs.get(0);
        }
        if ((IDATs = this.filterChunks(chunks, IDAT)).size() < 1) {
            throw new ImageReadException("PNG missing image data");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < IDATs.size(); ++i) {
            PNGChunkIDAT pngChunkIDAT = (PNGChunkIDAT)IDATs.get(i);
            byte[] bytes = pngChunkIDAT.bytes;
            baos.write(bytes);
        }
        byte[] compressed = baos.toByteArray();
        baos = null;
        TransparencyFilter transparencyFilter = null;
        ArrayList tRNSs = this.filterChunks(chunks, tRNS);
        if (tRNSs.size() > 0) {
            PNGChunk pngChunktRNS = (PNGChunk)tRNSs.get(0);
            transparencyFilter = this.getTransparencyFilter(pngChunkIHDR.colorType, pngChunktRNS);
        }
        ICC_Profile icc_profile = null;
        GammaCorrection gammaCorrection = null;
        ArrayList sRGBs = this.filterChunks(chunks, sRGB);
        ArrayList gAMAs = this.filterChunks(chunks, gAMA);
        ArrayList iCCPs = this.filterChunks(chunks, iCCP);
        if (sRGBs.size() > 1) {
            throw new ImageReadException("PNG: unexpected sRGB chunk");
        }
        if (gAMAs.size() > 1) {
            throw new ImageReadException("PNG: unexpected gAMA chunk");
        }
        if (iCCPs.size() > 1) {
            throw new ImageReadException("PNG: unexpected iCCP chunk");
        }
        if (sRGBs.size() == 1) {
            if (this.debug) {
                System.out.println("sRGB, no color management neccesary.");
            }
        } else if (iCCPs.size() == 1) {
            if (this.debug) {
                System.out.println("iCCP.");
            }
            PNGChunkiCCP pngChunkiCCP = (PNGChunkiCCP)iCCPs.get(0);
            byte[] bytes = pngChunkiCCP.UncompressedProfile;
            icc_profile = ICC_Profile.getInstance(bytes);
        } else if (gAMAs.size() == 1) {
            double targetGamma = 1.0;
            PNGChunkgAMA pngChunkgAMA = (PNGChunkgAMA)gAMAs.get(0);
            double gamma = pngChunkgAMA.getGamma();
            double diff = Math.abs(targetGamma - gamma);
            if (diff >= 0.5) {
                gammaCorrection = new GammaCorrection(gamma, targetGamma);
            }
            if (gammaCorrection != null && pngChunkPLTE != null) {
                pngChunkPLTE.correct(gammaCorrection);
            }
        }
        int width = pngChunkIHDR.width;
        int height = pngChunkIHDR.height;
        int colorType = pngChunkIHDR.colorType;
        int bitsPerSample = bitDepth = pngChunkIHDR.bitDepth;
        if (pngChunkIHDR.filterMethod != 0) {
            throw new ImageReadException("PNG: unknown FilterMethod: " + pngChunkIHDR.filterMethod);
        }
        int samplesPerPixel = this.samplesPerPixel(pngChunkIHDR.colorType);
        boolean isGrayscale = this.isGrayscale(pngChunkIHDR.colorType);
        int bitsPerPixel = bitsPerSample * samplesPerPixel;
        boolean hasAlpha = colorType == 4 || colorType == 6;
        BufferedImage result = isGrayscale ? this.getBufferedImageFactory(params).getGrayscaleBufferedImage(width, height, hasAlpha) : this.getBufferedImageFactory(params).getColorBufferedImage(width, height, hasAlpha);
        ByteArrayInputStream bais = new ByteArrayInputStream(compressed);
        InflaterInputStream iis = new InflaterInputStream(bais);
        if (pngChunkIHDR.interlaceMethod == 0) {
            scanExpediter = new ScanExpediterSimple(width, height, iis, result, colorType, bitDepth, bitsPerPixel, pngChunkPLTE, gammaCorrection, transparencyFilter);
        } else if (pngChunkIHDR.interlaceMethod == 1) {
            scanExpediter = new ScanExpediterInterlaced(width, height, iis, result, colorType, bitDepth, bitsPerPixel, pngChunkPLTE, gammaCorrection, transparencyFilter);
        } else {
            throw new ImageReadException("Unknown InterlaceMethod: " + pngChunkIHDR.interlaceMethod);
        }
        ((ScanExpediter)scanExpediter).drive();
        if (!(icc_profile == null || (is_srgb = new IccProfileParser().issRGB(icc_profile)) != null && is_srgb.booleanValue())) {
            ICC_ColorSpace cs = new ICC_ColorSpace(icc_profile);
            ColorModel srgbCM = ColorModel.getRGBdefault();
            ColorSpace cs_sRGB = srgbCM.getColorSpace();
            result = new ColorTools().convertBetweenColorSpaces(result, cs, cs_sRGB);
        }
        return result;
    }

    public boolean dumpImageFile(PrintWriter pw, ByteSource byteSource) throws ImageReadException, IOException {
        ImageInfo imageInfo = this.getImageInfo(byteSource);
        if (imageInfo == null) {
            return false;
        }
        imageInfo.toString(pw, "");
        ArrayList chunks = this.readChunks(byteSource, null, false);
        ArrayList IHDRs = this.filterChunks(chunks, IHDR);
        if (IHDRs.size() != 1) {
            if (this.debug) {
                System.out.println("PNG contains more than one Header");
            }
            return false;
        }
        PNGChunkIHDR pngChunkIHDR = (PNGChunkIHDR)IHDRs.get(0);
        pw.println("Color: " + this.getColorTypeDescription(pngChunkIHDR.colorType));
        pw.println("chunks: " + chunks.size());
        if (chunks.size() < 1) {
            return false;
        }
        for (int i = 0; i < chunks.size(); ++i) {
            PNGChunk chunk = (PNGChunk)chunks.get(i);
            this.printCharQuad(pw, "\t" + i + ": ", chunk.chunkType);
        }
        pw.println("");
        pw.flush();
        return true;
    }

    public void writeImage(BufferedImage src, OutputStream os, Map params) throws ImageWriteException, IOException {
        new PngWriter(params).writeImage(src, os, params);
    }

    public String getXmpXml(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        ArrayList chunks = this.readChunks(byteSource, new int[]{iTXt}, false);
        if (chunks == null || chunks.size() < 1) {
            return null;
        }
        ArrayList<PNGChunkiTXt> xmpChunks = new ArrayList<PNGChunkiTXt>();
        for (int i = 0; i < chunks.size(); ++i) {
            PNGChunkiTXt chunk = (PNGChunkiTXt)chunks.get(i);
            if (!chunk.getKeyword().equals("XML:com.adobe.xmp")) continue;
            xmpChunks.add(chunk);
        }
        if (xmpChunks.size() < 1) {
            return null;
        }
        if (xmpChunks.size() > 1) {
            throw new ImageReadException("PNG contains more than one XMP chunk.");
        }
        PNGChunkiTXt chunk = (PNGChunkiTXt)xmpChunks.get(0);
        return chunk.getText();
    }
}

