/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import org.im4java.core.ConvertCmd;
import org.im4java.core.IMOperation;
import org.im4java.core.Operation;
import org.im4java.core.Stream2BufferedImage;
import org.im4java.process.InputProvider;
import org.im4java.process.OutputConsumer;
import org.im4java.process.Pipe;

public class ImageMagickHelper {
    protected static Boolean m_ConvertPresent;

    public static boolean isConvertAvailable() {
        if (m_ConvertPresent == null) {
            try {
                Process proc = Runtime.getRuntime().exec("convert -version");
                m_ConvertPresent = proc.waitFor() == 0;
            }
            catch (Exception e) {
                m_ConvertPresent = false;
            }
        }
        return m_ConvertPresent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage read(File file) {
        BufferedImage result;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file.getAbsoluteFile());
            result = ImageMagickHelper.read(stream);
        }
        catch (Exception e) {
            result = null;
            System.err.println("Failed to read image from '" + file + "':");
            e.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage read(URL url) {
        BufferedImage result;
        InputStream stream = null;
        try {
            stream = url.openStream();
            result = ImageMagickHelper.read(stream);
        }
        catch (Exception e) {
            result = null;
            System.err.println("Failed to read image from '" + url + "':");
            e.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    public static BufferedImage read(InputStream stream) {
        BufferedImage result;
        IMOperation op = new IMOperation();
        op.addImage(new String[]{"-"});
        op.addImage(new String[]{"-"});
        Stream2BufferedImage s2b = new Stream2BufferedImage();
        ConvertCmd cmd = new ConvertCmd();
        cmd.setInputProvider((InputProvider)new Pipe(stream, null));
        cmd.setOutputConsumer((OutputConsumer)s2b);
        try {
            cmd.run((Operation)op, new Object[0]);
            result = s2b.getImage();
        }
        catch (Exception e) {
            result = null;
            System.err.println("Failed to read image from stream:");
            e.printStackTrace();
        }
        return result;
    }
}

