/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.data.image.AbstractImage;
import adams.data.jai.BufferedImageContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.awt.Color;
import java.awt.image.BufferedImage;

public class SetImagePixel
extends AbstractTransformer {
    private static final long serialVersionUID = -992178802927111511L;
    protected int m_X;
    protected int m_Y;
    protected PixelValueType m_Type;
    protected int m_RGBA;
    protected Color m_Color;

    public String globalInfo() {
        return "Obtains information from the picture passing through.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("x", "X", (Object)1, (Number)1, null);
        this.m_OptionManager.add("y", "Y", (Object)1, (Number)1, null);
        this.m_OptionManager.add("type", "type", (Object)PixelValueType.RGBA);
        this.m_OptionManager.add("rgba", "RGBA", (Object)0, (Number)0, null);
        this.m_OptionManager.add("color", "color", (Object)Color.BLACK);
    }

    public String getQuickInfo() {
        String result = null;
        String variable = this.getOptionManager().getVariableForProperty("X");
        result = variable != null ? variable : "" + this.m_X;
        result = result + "/";
        variable = this.getOptionManager().getVariableForProperty("Y");
        result = variable != null ? result + variable : result + "" + this.m_Y;
        result = result + ": ";
        switch (this.m_Type) {
            case RGBA: {
                variable = this.getOptionManager().getVariableForProperty("RGBA");
                if (variable != null) {
                    result = result + variable + " (RGBA)";
                    break;
                }
                result = result + "" + this.m_RGBA;
                break;
            }
            case COLOR: {
                variable = this.getOptionManager().getVariableForProperty("color");
                result = variable != null ? result + variable : result + "" + this.m_Color + " (Color)";
            }
        }
        return result;
    }

    public void setX(int value) {
        if (value > 0) {
            this.m_X = value;
            this.reset();
        } else {
            this.getSystemErr().println("X must be >0, provided: " + value);
        }
    }

    public int getX() {
        return this.m_X;
    }

    public String XTipText() {
        return "The X position of the pixel (1-based).";
    }

    public void setY(int value) {
        if (value > 0) {
            this.m_Y = value;
            this.reset();
        } else {
            this.getSystemErr().println("Y must be >0, provided: " + value);
        }
    }

    public int getY() {
        return this.m_Y;
    }

    public String YTipText() {
        return "The Y position of the pixel (1-based).";
    }

    public void setType(PixelValueType value) {
        this.m_Type = value;
        this.reset();
    }

    public PixelValueType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of value to use for the pixel.";
    }

    public void setRGBA(int value) {
        if (value >= 0) {
            this.m_RGBA = value;
            this.reset();
        } else {
            this.getSystemErr().println("RGBA must be >=0, provided: " + value);
        }
    }

    public int getRGBA() {
        return this.m_RGBA;
    }

    public String RGBATipText() {
        return "The RGBA value (>= 0).";
    }

    public void setColor(Color value) {
        this.m_Color = value;
        this.reset();
    }

    public Color getColor() {
        return this.m_Color;
    }

    public String colorTipText() {
        return "The color of the pixel.";
    }

    public Class[] accepts() {
        return new Class[]{AbstractImage.class};
    }

    public Class[] generates() {
        return new Class[]{BufferedImageContainer.class};
    }

    protected String doExecute() {
        String result = null;
        AbstractImage image = (AbstractImage)this.m_InputToken.getPayload();
        if (this.m_X > image.getWidth()) {
            result = "X is larger than image width: " + this.m_X + " > " + image.getWidth();
        } else if (this.m_Y > image.getHeight()) {
            result = "Y is larger than image height: " + this.m_Y + " > " + image.getHeight();
        }
        if (result == null) {
            BufferedImageContainer cont = new BufferedImageContainer();
            cont.setReport(image.getReport().getClone());
            cont.setImage(image.toBufferedImage());
            switch (this.m_Type) {
                case RGBA: {
                    ((BufferedImage)cont.getImage()).setRGB(this.m_X - 1, this.m_Y - 1, this.m_RGBA);
                    break;
                }
                case COLOR: {
                    ((BufferedImage)cont.getImage()).setRGB(this.m_X - 1, this.m_Y - 1, this.m_Color.getRGB());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled pixel value type: " + (Object)((Object)this.m_Type));
                }
            }
            if (this.isDebugOn()) {
                this.debug("X=" + this.m_X + ", Y=" + this.m_Y + " -> " + this.m_RGBA);
            }
            this.m_OutputToken = new Token((Object)cont);
        }
        return result;
    }

    public static enum PixelValueType {
        RGBA,
        COLOR;

    }
}

