/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.ConsoleObject;
import adams.core.SerializableObject;
import adams.core.SerializationHelper;
import adams.core.option.ArrayProducer;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import java.util.HashSet;

public class SerializableObjectHelper
extends ConsoleObject {
    private static final long serialVersionUID = -6245176175718570463L;
    protected SerializableObject m_Owner;
    protected boolean m_SetupLoadedOrGenerated;

    public SerializableObjectHelper(SerializableObject owner) {
        this.m_Owner = owner;
        this.m_SetupLoadedOrGenerated = false;
    }

    public SerializableObject getOwner() {
        return this.m_Owner;
    }

    public void reset() {
        this.m_SetupLoadedOrGenerated = false;
    }

    protected String getCommandLine(Object obj) {
        String result;
        if (obj instanceof OptionHandler) {
            HashSet<String> skipped = new HashSet<String>();
            skipped.add("serializationFile");
            skipped.add("overrideSerializedFile");
            ArrayProducer producer = new ArrayProducer();
            producer.setSkippedProperties(skipped);
            producer.produce((OptionHandler)obj);
            result = producer.toString();
            producer.cleanUp();
        } else {
            result = OptionUtils.getCommandLine(obj);
        }
        return result;
    }

    public void loadSetup() {
        if (this.m_SetupLoadedOrGenerated && !this.m_Owner.getOverrideSerializedFile()) {
            return;
        }
        boolean generate = false;
        if (this.m_Owner.getOverrideSerializedFile() || this.m_Owner.getSerializationFile().isDirectory() || !this.m_Owner.getSerializationFile().exists()) {
            generate = true;
        } else {
            Object[] fullSetup = null;
            try {
                fullSetup = SerializationHelper.readAll(this.m_Owner.getSerializationFile().getAbsolutePath());
            }
            catch (Exception e) {
                fullSetup = null;
                this.getSystemErr().println("Error deserializing from '" + this.m_Owner.getSerializationFile() + "':");
                this.getSystemErr().printStackTrace(e);
            }
            if (fullSetup == null) {
                generate = true;
            } else {
                String options;
                Object[] setup = new Object[fullSetup.length - 1];
                if (fullSetup.length > 1) {
                    System.arraycopy(fullSetup, 1, setup, 0, fullSetup.length - 1);
                }
                if (!(options = (String)fullSetup[0]).equals(this.getCommandLine(this.m_Owner))) {
                    generate = true;
                } else {
                    this.m_Owner.setSerializationSetup(setup);
                    this.m_SetupLoadedOrGenerated = true;
                }
            }
        }
        if (generate) {
            this.generateSetup();
            if (!this.m_Owner.getSerializationFile().isDirectory()) {
                this.saveSetup();
            }
            this.m_SetupLoadedOrGenerated = true;
        }
    }

    public void saveSetup() {
        if (this.m_Owner.getSerializationFile().isDirectory()) {
            return;
        }
        try {
            Object[] setup = this.m_Owner.retrieveSerializationSetup();
            Object[] fullSetup = new Object[setup.length + 1];
            fullSetup[0] = this.getCommandLine(this.m_Owner);
            if (setup.length > 0) {
                System.arraycopy(setup, 0, fullSetup, 1, setup.length);
            }
            SerializationHelper.writeAll(this.m_Owner.getSerializationFile().getAbsolutePath(), fullSetup);
        }
        catch (Exception e) {
            this.getSystemErr().println("Error serializing to '" + this.m_Owner.getSerializationFile() + "':");
            this.getSystemErr().printStackTrace(e);
        }
    }

    public void generateSetup() {
        this.m_Owner.initSerializationSetup();
    }

    public String toString() {
        String result = "Owner=" + this.m_Owner.getClass().getName() + ", " + "File=" + this.m_Owner.getSerializationFile() + ", " + "IsDirectory=" + this.m_Owner.getSerializationFile().isDirectory() + ", " + "Override=" + this.m_Owner.getOverrideSerializedFile();
        return result;
    }
}

