/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.ClassCrossReference;
import adams.core.Utils;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractNumericOption;
import adams.core.option.AbstractOption;
import adams.core.option.AbstractOptionProducer;
import adams.core.option.BooleanOption;
import adams.core.option.ClassOption;
import adams.core.option.EnumOption;
import adams.core.option.OptionManager;
import java.lang.reflect.Array;
import java.lang.reflect.Method;

public class CommandlineHelpProducer
extends AbstractOptionProducer<String, StringBuilder> {
    private static final long serialVersionUID = 4154358361484863539L;
    public static final int MAX_WIDTH = 72;
    protected StringBuilder m_OutputBuffer;

    @Override
    public String globalInfo() {
        return "Generates help output, that is output on the command-line.";
    }

    @Override
    protected String initOutput() {
        return "";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_OutputBuffer = new StringBuilder();
    }

    @Override
    public String getOutput() {
        if (this.m_Output == null) {
            this.m_Output = this.m_OutputBuffer.toString();
        }
        return (String)this.m_Output;
    }

    protected void addToolTip(AbstractOption option, StringBuilder buffer) {
        if (option.getToolTipMethod() != null) {
            try {
                String text = (String)option.getToolTipMethod().invoke((Object)option.getOptionHandler(), new Object[0]);
                String[] lines = Utils.breakUp(text, 72);
                for (int i = 0; i < lines.length; ++i) {
                    buffer.append("\t");
                    buffer.append(lines[i]);
                    buffer.append("\n");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void addArgumentInfo(AbstractArgumentOption option, StringBuilder buffer) {
        String text;
        if (option instanceof EnumOption) {
            text = "";
            try {
                Method method = option.getBaseClass().getMethod("values", new Class[0]);
                Object[] vals = (Object[])method.invoke(null, new Object[0]);
                text = Utils.arrayToString(vals).replaceAll(",", "|");
            }
            catch (Exception e) {
                e.printStackTrace();
                text = "Error retrieving enum values";
            }
        } else {
            text = option.getBaseClass().getName();
        }
        buffer.append(" <" + text + ">");
    }

    @Override
    public StringBuilder processOption(BooleanOption option) {
        StringBuilder result = new StringBuilder();
        result.append("-" + option.getCommandline());
        result.append(" (property: " + option.getProperty() + ")");
        result.append("\n");
        this.addToolTip(option, result);
        this.m_OutputBuffer.append((CharSequence)result);
        return result;
    }

    @Override
    public StringBuilder processOption(ClassOption option) {
        return this.processOption((AbstractArgumentOption)option);
    }

    @Override
    public StringBuilder processOption(AbstractArgumentOption option) {
        StringBuilder result = new StringBuilder();
        result.append("-" + option.getCommandline());
        this.addArgumentInfo(option, result);
        if (option.isMultiple()) {
            result.append(" [");
            result.append("-" + option.getCommandline());
            result.append(" ...]");
        }
        result.append(" (property: " + option.getProperty() + ")");
        result.append("\n");
        this.addToolTip(option, result);
        if (option.getOutputDefaultValue()) {
            String text = null;
            Object defValue = option.getDefaultValue();
            if (defValue == null) {
                text = "null";
            } else if (option.isMultiple()) {
                text = "";
                for (int n = 0; n < Array.getLength(defValue); ++n) {
                    if (n > 0) {
                        text = text + ", ";
                    }
                    text = text + option.toString(Array.get(defValue, n));
                }
            } else {
                text = option.toString(defValue);
            }
            result.append("\tdefault: " + Utils.backQuoteChars(text) + "\n");
        }
        if (option instanceof AbstractNumericOption) {
            AbstractNumericOption numeric = (AbstractNumericOption)option;
            if (numeric.hasLowerBound()) {
                result.append("\tminimum: " + numeric.getLowerBound() + "\n");
            }
            if (numeric.hasUpperBound()) {
                result.append("\tmaximum: " + numeric.getUpperBound() + "\n");
            }
        }
        this.m_OutputBuffer.append((CharSequence)result);
        return result;
    }

    @Override
    protected void preProduce(OptionManager manager, int index) {
        super.preProduce(manager, index);
        this.m_Output = null;
    }

    @Override
    protected void preProduce() {
        this.m_OutputBuffer = new StringBuilder();
        this.m_OutputBuffer.append("Command-line help\n");
        this.m_OutputBuffer.append("=================\n");
        this.m_OutputBuffer.append("\n");
        this.m_OutputBuffer.append(this.getInput().getClass().getName() + "\n");
        this.m_OutputBuffer.append("\n");
        try {
            Method method = this.getInput().getClass().getMethod("globalInfo", new Class[0]);
            if (method != null) {
                String globalInfo = (String)method.invoke((Object)this.getInput(), new Object[0]);
                this.m_OutputBuffer.append(Utils.insertLineBreaks(globalInfo, 72));
                this.m_OutputBuffer.append("\n");
            }
            if (this.getInput() instanceof ClassCrossReference) {
                this.m_OutputBuffer.append("See also:\n");
                Class[] cross = ((ClassCrossReference)((Object)this.getInput())).getClassCrossReferences();
                for (int i = 0; i < cross.length; ++i) {
                    this.m_OutputBuffer.append(cross[i].getName() + "\n");
                }
                this.m_OutputBuffer.append("\n");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Override
    public String toString() {
        return this.getOutput();
    }
}

