/*
 * Decompiled with CFR 0.152.
 */
package adams.data.outlier;

import adams.data.container.DataContainer;
import adams.data.outlier.AbstractDatabaseConnectionOutlierDetector;
import adams.data.outlier.AbstractOutlierDetector;
import adams.data.outlier.PassThrough;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.db.DatabaseConnectionHandler;
import java.util.Vector;

public class MultiOutlierDetector<T extends DataContainer>
extends AbstractDatabaseConnectionOutlierDetector<T> {
    private static final long serialVersionUID = 5818338370944478215L;
    protected AbstractOutlierDetector[] m_Detectors;
    protected boolean m_StopOnFirstDetection;

    @Override
    public String globalInfo() {
        return "A meta-detector that runs multiple outlier detectors over the data.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("detector", "subDetectors", new AbstractOutlierDetector[]{new PassThrough()});
        this.m_OptionManager.add("stop", "stopOnFirstDetection", false);
    }

    @Override
    protected AbstractDatabaseConnection getDefaultDatabaseConnection() {
        return DatabaseConnection.getSingleton();
    }

    public String subDetectorsTipText() {
        return "The array of outlier detectors to use.";
    }

    public void setSubDetectors(AbstractOutlierDetector[] value) {
        if (value != null) {
            this.m_Detectors = value;
            this.updateDatabaseConnection();
            this.reset();
        } else {
            this.getSystemErr().println(this.getClass().getName() + ": detectors cannot be null!");
        }
    }

    public AbstractOutlierDetector[] getSubDetectors() {
        return this.m_Detectors;
    }

    public void setStopOnFirstDetection(boolean value) {
        this.m_StopOnFirstDetection = value;
        this.reset();
    }

    public boolean getStopOnFirstDetection() {
        return this.m_StopOnFirstDetection;
    }

    public String stopOnFirstDetectionTipText() {
        return "If set to true, the detection process will be stopped as soon as one of the sub-detecors detected an outlier.";
    }

    @Override
    protected void updateDatabaseConnection() {
        for (AbstractOutlierDetector detector : this.m_Detectors) {
            if (!(detector instanceof DatabaseConnectionHandler)) continue;
            ((DatabaseConnectionHandler)((Object)detector)).setDatabaseConnection(this.getDatabaseConnection());
        }
    }

    @Override
    protected Vector<String> processData(T data) {
        Vector<String> result = new Vector<String>();
        for (int i = 0; i < this.m_Detectors.length; ++i) {
            Vector<String> detection = AbstractOutlierDetector.detect(this.m_Detectors[i].shallowCopy(true), data);
            if (detection.size() <= 0) continue;
            result.addAll(detection);
            if (this.m_StopOnFirstDetection) break;
        }
        if (this.isDebugOn() && result.size() > 0) {
            this.debug(data + " - " + this.getClass().getName() + ": " + result);
        }
        return result;
    }
}

