/*
 * Decompiled with CFR 0.152.
 */
package adams.data.statistics;

import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.data.statistics.AbstractArrayStatistic;
import adams.data.statistics.EqualLengthArrayStatistic;
import adams.data.statistics.StatUtils;

public class ArrayHistogram<T extends Number>
extends AbstractArrayStatistic<T>
implements EqualLengthArrayStatistic,
TechnicalInformationHandler {
    private static final long serialVersionUID = 3595293227007460735L;
    public static final String METADATA_NUMBINS = "num-bins";
    public static final String METADATA_BINWIDTH = "bin-width";
    public static final String METADATA_BINX = "bin-x";
    protected BinCalculation m_BinCalculation;
    protected int m_NumBins;
    protected double m_BinWidth;
    protected boolean m_Normalize;

    @Override
    public String globalInfo() {
        return "Generates a histogram from the given array.\nThe formulas for the various width/#bin calculations can be found here:\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.YEAR, "2010");
        result.setValue(TechnicalInformation.Field.AUTHOR, "WikiPedia");
        result.setValue(TechnicalInformation.Field.TITLE, "Histogram");
        result.setValue(TechnicalInformation.Field.HTTP, "http://en.wikipedia.org/wiki/Histogram");
        return result;
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("bin-calc", "binCalculation", (Object)BinCalculation.MANUAL);
        this.m_OptionManager.add(METADATA_NUMBINS, "numBins", 50, 1, null);
        this.m_OptionManager.add(METADATA_BINWIDTH, "binWidth", 1.0, 1.0E-5, null);
        this.m_OptionManager.add("normalize", "normalize", false);
    }

    public void setBinCalculation(BinCalculation value) {
        this.m_BinCalculation = value;
        this.reset();
    }

    public BinCalculation getBinCalculation() {
        return this.m_BinCalculation;
    }

    public String binCalculationTipText() {
        return "Defines how the number of bins are calculated.";
    }

    public void setNumBins(int value) {
        this.m_NumBins = value;
        this.reset();
    }

    public int getNumBins() {
        return this.m_NumBins;
    }

    public String numBinsTipText() {
        return "The number of bins to use in case of manual bin calculation.";
    }

    public void setBinWidth(double value) {
        this.m_BinWidth = value;
        this.reset();
    }

    public double getBinWidth() {
        return this.m_BinWidth;
    }

    public String binWidthTipText() {
        return "The bin width to use for some of the calculations.";
    }

    public void setNormalize(boolean value) {
        this.m_Normalize = value;
        this.reset();
    }

    public boolean getNormalize() {
        return this.m_Normalize;
    }

    public String normalizeTipText() {
        return "If set to true the data gets normalized first before the histogram is calculated.";
    }

    @Override
    public int getLength() {
        if (this.size() > 0) {
            return ((Number[])this.get(0)).length;
        }
        return -1;
    }

    @Override
    public int getMin() {
        return 1;
    }

    @Override
    public int getMax() {
        return 1;
    }

    protected double calcBinWidth(Number[] array) {
        int numPoints = array.length;
        switch (this.m_BinCalculation) {
            case MANUAL: {
                double min = StatUtils.min(array).doubleValue();
                double max = StatUtils.max(array).doubleValue();
                return (max - min) / (double)this.m_NumBins;
            }
            case DENSITY: {
                return this.m_BinWidth;
            }
            case STURGES: {
                return -1.0;
            }
            case SCOTT: {
                double stdev = StatUtils.stddev(array, true);
                return 3.5 * stdev / Math.pow(numPoints, 0.0);
            }
            case SQRT: {
                return -1.0;
            }
        }
        throw new IllegalStateException("Unhandled bin width calculation: " + (Object)((Object)this.m_BinCalculation));
    }

    protected int calcNumBins(Number[] array, double width) {
        int numPoints = array.length;
        switch (this.m_BinCalculation) {
            case MANUAL: {
                return this.m_NumBins;
            }
            case DENSITY: 
            case SCOTT: {
                double min = StatUtils.min(array).doubleValue();
                double max = StatUtils.max(array).doubleValue();
                return (int)Math.ceil((max - min) / width);
            }
            case STURGES: {
                return (int)Math.ceil(Math.log(numPoints) / Math.log(2.0) + 1.0);
            }
            case SQRT: {
                return (int)Math.round(Math.sqrt(numPoints));
            }
        }
        throw new IllegalStateException("Unhandled bin calculation: " + (Object)((Object)this.m_BinCalculation));
    }

    @Override
    protected AbstractArrayStatistic.StatisticContainer doCalculate() {
        int n;
        Number[] array = (Number[])this.get(0);
        if (this.m_Normalize) {
            array = StatUtils.normalize(array);
        }
        String prefix = "bin";
        double binWidth = this.calcBinWidth(array);
        int numBins = this.calcNumBins(array, binWidth);
        AbstractArrayStatistic.StatisticContainer<Double> result = new AbstractArrayStatistic.StatisticContainer<Double>(this.size(), numBins);
        for (n = 0; n < numBins; ++n) {
            result.setHeader(n, prefix + " " + (n + 1));
        }
        double min = StatUtils.min(array).doubleValue();
        double max = StatUtils.max(array).doubleValue();
        binWidth = (max - min) / (double)numBins;
        int[] bins = new int[numBins];
        for (n = 0; n < array.length; ++n) {
            int bin = (int)Math.floor((array[n].doubleValue() - min) / binWidth);
            if (bin == numBins) {
                // empty if block
            }
            int n2 = --bin;
            bins[n2] = bins[n2] + 1;
        }
        double[] binX = new double[numBins];
        for (n = 0; n < bins.length; ++n) {
            binX[n] = min + (double)n * binWidth;
            result.setCell(0, n, new Double(bins[n]));
        }
        result.setMetaData(METADATA_NUMBINS, numBins);
        result.setMetaData(METADATA_BINWIDTH, binWidth);
        result.setMetaData(METADATA_BINX, binX);
        return result;
    }

    public static enum BinCalculation {
        MANUAL,
        DENSITY,
        STURGES,
        SCOTT,
        SQRT;

    }
}

