/*
 * Decompiled with CFR 0.152.
 */
package adams.db.upgrade;

import adams.core.ClassLister;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionUtils;
import adams.db.AbstractDatabaseObjectWithOptionHandling;
import adams.db.DatabaseConnection;
import adams.event.DatabaseConnectionChangeEvent;

public abstract class AbstractTableUpgrade
extends AbstractDatabaseObjectWithOptionHandling {
    private static final long serialVersionUID = 5174695729150073016L;
    protected StringBuffer m_UpgradeInfo;
    protected boolean m_Upgraded;

    @Override
    public abstract String globalInfo();

    @Override
    protected void initialize() {
        super.initialize();
        this.m_UpgradeInfo = new StringBuffer();
    }

    @Override
    public void reset() {
        super.reset();
        this.m_UpgradeInfo = new StringBuffer();
        this.m_Upgraded = false;
    }

    protected void addInfo(String s) {
        this.m_UpgradeInfo.append(s);
        this.m_UpgradeInfo.append("\n");
    }

    protected void preUpgrade() {
        this.setDatabaseConnection(this.createDatabaseConnection());
    }

    protected abstract void doUpgrade();

    protected void postUpgrade() {
        DatabaseConnection.getSingleton().notifyChangeListeners(new DatabaseConnectionChangeEvent(DatabaseConnection.getSingleton(), DatabaseConnectionChangeEvent.Type.GENERAL));
    }

    public StringBuffer upgrade() {
        if (!this.m_Upgraded) {
            this.addInfo("1. preUpgrade\n");
            this.debug("Entering 'preUpgrade'...");
            this.preUpgrade();
            this.addInfo("\n2. doUpgrade\n");
            this.debug("Entering 'doUpgrade'...");
            this.doUpgrade();
            this.addInfo("\n3. postUpgrade\n");
            this.debug("Entering 'postUpgrade'...");
            this.postUpgrade();
            this.debug("Finished.");
        }
        this.m_Upgraded = true;
        return this.m_UpgradeInfo;
    }

    public static String[] getUpgraders() {
        return ClassLister.getSingleton().getClassnames(AbstractTableUpgrade.class);
    }

    public static AbstractTableUpgrade forName(String classname, String[] options) {
        AbstractTableUpgrade result;
        try {
            result = (AbstractTableUpgrade)OptionUtils.forName(AbstractTableUpgrade.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static AbstractTableUpgrade forCommandLine(String cmdline) {
        return (AbstractTableUpgrade)AbstractOptionConsumer.fromString(ArrayConsumer.class, cmdline);
    }
}

