/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.flow.condition.bool.AbstractBooleanCondition;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.core.Unknown;

public class Or
extends AbstractBooleanCondition {
    private static final long serialVersionUID = -7930281929775307418L;
    protected AbstractBooleanCondition[] m_Conditions;

    @Override
    public String globalInfo() {
        return "Performs a logical OR over all its sub-conditions, i.e., it evaluates to 'true' if any of the sub-conditions evaluates to 'true' as well.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("condition", "conditions", new AbstractBooleanCondition[0]);
    }

    public void setConditions(AbstractBooleanCondition[] value) {
        this.m_Conditions = value;
        this.reset();
    }

    public AbstractBooleanCondition[] getConditions() {
        return this.m_Conditions;
    }

    public String conditionsTipText() {
        return "The conditions to use for the logical OR.";
    }

    @Override
    public String getQuickInfo() {
        return this.m_Conditions.length + " condition" + (this.m_Conditions.length != 1 ? "s" : "");
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public String setUp() {
        String result = null;
        if (this.m_Conditions.length == 0) {
            result = "No conditions provided!";
        }
        return result;
    }

    @Override
    protected boolean doEvaluate(AbstractActor owner, Token token) {
        boolean result = false;
        for (AbstractBooleanCondition condition : this.m_Conditions) {
            if (!condition.evaluate(owner, token)) continue;
            result = true;
            break;
        }
        return result;
    }
}

