/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.ClassCrossReference;
import adams.core.io.PlaceholderFile;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.BaseName;
import adams.flow.transformer.DirName;
import adams.flow.transformer.FileExtension;
import java.io.File;

public class PrependDir
extends AbstractTransformer
implements ClassCrossReference {
    private static final long serialVersionUID = 1960630826702728371L;
    protected String m_Prefix;
    protected boolean m_NoSeparator;

    @Override
    public String globalInfo() {
        return "Prepends the prefix to the file/directory being passed through.\n By default, the appropriate separator (forward slash or backslash) gets inserted between the file/directory and prefix. This can be turned off.\n";
    }

    @Override
    public Class[] getClassCrossReferences() {
        return new Class[]{BaseName.class, DirName.class, FileExtension.class};
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefix", "");
        this.m_OptionManager.add("no-separator", "noSeparator", false);
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("prefix");
        if (variable != null) {
            return variable;
        }
        return this.m_Prefix;
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The prefix to append to the file/directory.";
    }

    public void setNoSeparator(boolean value) {
        this.m_NoSeparator = value;
        this.reset();
    }

    public boolean getNoSeparator() {
        return this.m_NoSeparator;
    }

    public String noSeparatorTipText() {
        return "If enabled, no separator (forward slash or backslash) gets inserted between prefix and file/directory.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class, String[].class, File.class, File[].class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class, String[].class, File.class, File[].class};
    }

    @Override
    protected String doExecute() {
        int i;
        File[] files;
        String[] strings;
        String result = null;
        boolean array = false;
        boolean string = false;
        if (this.m_InputToken.getPayload() instanceof File) {
            strings = new String[]{new PlaceholderFile((File)this.m_InputToken.getPayload()).getAbsolutePath()};
        } else if (this.m_InputToken.getPayload() instanceof File[]) {
            files = (File[])this.m_InputToken.getPayload();
            strings = new String[files.length];
            array = true;
            for (i = 0; i < files.length; ++i) {
                strings[i] = new PlaceholderFile(files[i]).getAbsolutePath();
            }
        } else if (this.m_InputToken.getPayload() instanceof String) {
            strings = new String[]{(String)this.m_InputToken.getPayload()};
            string = true;
        } else if (this.m_InputToken.getPayload() instanceof String[]) {
            strings = (String[])this.m_InputToken.getPayload();
            array = true;
            string = true;
        } else {
            throw new IllegalStateException("Unhandled input type: " + this.m_InputToken.getPayload().getClass());
        }
        files = new File[strings.length];
        for (i = 0; i < strings.length; ++i) {
            files[i] = this.m_NoSeparator ? new PlaceholderFile(this.m_Prefix + strings[i]) : new PlaceholderFile(this.m_Prefix + File.separator + strings[i]);
            if (!string) continue;
            strings[i] = files[i].toString();
        }
        this.m_OutputToken = string ? (array ? new Token(strings) : new Token(strings[0])) : (array ? new Token(files) : new Token(files[0]));
        return result;
    }
}

