/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.core.CleanUpHandler;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.KeyUtils;
import adams.gui.core.MouseUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractChooserPanel<T>
extends BasePanel
implements CleanUpHandler {
    private static final long serialVersionUID = -824479551072915989L;
    protected AbstractChooserPanel m_Self;
    protected JTextField m_TextSelection;
    protected JLabel m_LabelPrefix;
    protected JLabel m_LabelPrefixSpacer;
    protected JButton m_ButtonSelection;
    protected HashSet<ChangeListener> m_ChangeListeners;
    protected PopupMenuCustomizer m_PopupMenuCustomizer;

    protected AbstractChooserPanel() {
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Self = this;
        this.m_ChangeListeners = new HashSet();
    }

    @Override
    protected void initGUI() {
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new BorderLayout());
        this.m_LabelPrefix = new JLabel("");
        this.m_LabelPrefixSpacer = new JLabel("");
        panel.add((Component)this.m_LabelPrefix, "Center");
        panel.add((Component)this.m_LabelPrefixSpacer, "East");
        this.add((Component)panel, "West");
        this.m_TextSelection = new JTextField(this.getSelectionColumns());
        this.m_TextSelection.setText(this.getDefaultString());
        this.m_TextSelection.setEditable(false);
        this.m_TextSelection.setPreferredSize(new Dimension(this.m_TextSelection.getPreferredSize().width, this.m_TextSelection.getPreferredSize().height + 4));
        this.m_TextSelection.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isDoubleClick(e)) {
                    e.consume();
                    AbstractChooserPanel.this.choose();
                } else if (MouseUtils.isRightClick(e)) {
                    e.consume();
                    JPopupMenu menu = AbstractChooserPanel.this.getPopupMenu();
                    if (menu != null) {
                        menu.show(AbstractChooserPanel.this.m_TextSelection, e.getX(), e.getY());
                    }
                } else {
                    super.mouseClicked(e);
                }
            }
        });
        this.m_TextSelection.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (KeyUtils.isCopy(e)) {
                    AbstractChooserPanel.this.copyToClipboard();
                } else if (KeyUtils.isPaste(e) && GUIHelper.canPasteStringFromClipboard()) {
                    AbstractChooserPanel.this.pasteFromClipboard();
                }
                if (!e.isConsumed()) {
                    super.keyPressed(e);
                }
            }
        });
        this.add((Component)this.m_TextSelection, "Center");
        this.m_ButtonSelection = new JButton("...");
        this.m_ButtonSelection.setPreferredSize(new Dimension(this.m_ButtonSelection.getPreferredSize().width, this.m_TextSelection.getPreferredSize().height));
        this.m_ButtonSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractChooserPanel.this.choose();
            }
        });
        this.add((Component)this.m_ButtonSelection, "East");
        this.updatePreferredSize();
    }

    protected int getSelectionColumns() {
        return 30;
    }

    public void setPrefix(String value) {
        char mnemonic = GUIHelper.getMnemonic(value);
        String caption = GUIHelper.stripMnemonic(value);
        this.m_LabelPrefix.setText(caption);
        if (mnemonic != '\u0000') {
            this.m_LabelPrefix.setDisplayedMnemonic(mnemonic);
        } else {
            this.m_LabelPrefix.setDisplayedMnemonicIndex(-1);
        }
        if (value.length() > 0) {
            this.m_LabelPrefixSpacer.setText(" ");
        } else {
            this.m_LabelPrefixSpacer.setText("");
        }
    }

    public String getPrefix() {
        return this.m_LabelPrefix.getText();
    }

    public JLabel getPrefixLabel() {
        return this.m_LabelPrefix;
    }

    protected String getDefaultString() {
        return "";
    }

    protected abstract String toString(T var1);

    public boolean setCurrent(T value) {
        boolean result = true;
        String str = this.getDefaultString();
        if (value != null) {
            try {
                str = this.toString(value);
            }
            catch (Exception e) {
                e.printStackTrace();
                str = this.getDefaultString();
                result = false;
            }
        }
        this.m_TextSelection.setText(str);
        this.m_TextSelection.setCaretPosition(0);
        return result;
    }

    public void fireCurrentValueChanged() {
        this.notifyChangeListeners(new ChangeEvent(this.m_Self));
    }

    protected abstract T fromString(String var1);

    public T getCurrent() {
        return this.fromString(this.m_TextSelection.getText());
    }

    protected void copyToClipboard() {
        GUIHelper.copyToClipboard(this.m_TextSelection.getText());
    }

    protected void pasteFromClipboard() {
        try {
            this.setCurrent(this.fromString(GUIHelper.pasteSetupFromClipboard()));
            this.notifyChangeListeners(new ChangeEvent(this.m_Self));
        }
        catch (Exception e) {
            e.printStackTrace();
            GUIHelper.showErrorMessage(this, "Error processing clipboard content:\n" + e);
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.m_ChangeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.m_ChangeListeners.remove(l);
    }

    protected void notifyChangeListeners(ChangeEvent e) {
        Iterator<ChangeListener> iter = this.m_ChangeListeners.iterator();
        while (iter.hasNext()) {
            iter.next().stateChanged(e);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_ButtonSelection.setEnabled(enabled);
        this.m_TextSelection.setEnabled(enabled);
    }

    protected abstract T doChoose();

    protected void choose() {
        T value = this.doChoose();
        if (value != null) {
            this.setCurrent(value);
            this.fireCurrentValueChanged();
        }
    }

    public boolean hasValue() {
        return !this.m_TextSelection.getText().equals(this.getDefaultString());
    }

    protected void updatePreferredSize() {
        if (this.m_LabelPrefix.getText().length() == 0) {
            this.setPreferredSize(new Dimension(this.m_TextSelection.getPreferredSize().width + this.m_ButtonSelection.getPreferredSize().width, this.m_TextSelection.getPreferredSize().height));
        } else {
            this.setPreferredSize(new Dimension(this.m_LabelPrefix.getPreferredSize().width + this.m_LabelPrefixSpacer.getPreferredSize().width + this.m_TextSelection.getPreferredSize().width + this.m_ButtonSelection.getPreferredSize().width, this.m_TextSelection.getPreferredSize().height));
        }
    }

    public void setTextColumns(int value) {
        if (value > 0) {
            this.m_TextSelection.setColumns(value);
        } else {
            System.err.println("Number of columns must be >0 (provided: " + value + ")!");
        }
        this.updatePreferredSize();
    }

    public int getTextColumns() {
        return this.m_TextSelection.getColumns();
    }

    @Override
    public void grabFocus() {
        this.m_TextSelection.grabFocus();
    }

    protected JPopupMenu getPopupMenu() {
        JPopupMenu result = new JPopupMenu();
        JMenuItem menuitem = new JMenuItem("Copy");
        menuitem.setAccelerator(GUIHelper.getKeyStroke("control pressed C"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractChooserPanel.this.copyToClipboard();
            }
        });
        result.add(menuitem);
        menuitem = new JMenuItem("Paste");
        menuitem.setAccelerator(GUIHelper.getKeyStroke("control pressed V"));
        menuitem.setEnabled(GUIHelper.canPasteStringFromClipboard());
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractChooserPanel.this.pasteFromClipboard();
            }
        });
        result.add(menuitem);
        if (this.m_PopupMenuCustomizer != null) {
            result.addSeparator();
            this.m_PopupMenuCustomizer.customizePopup(this, result);
        }
        return result;
    }

    public void setPopupMenuCustomizer(PopupMenuCustomizer value) {
        this.m_PopupMenuCustomizer = value;
    }

    public PopupMenuCustomizer getPopupMenuCustomizer() {
        return this.m_PopupMenuCustomizer;
    }

    @Override
    public void cleanUp() {
    }

    public static interface PopupMenuCustomizer {
        public void customizePopup(AbstractChooserPanel var1, JPopupMenu var2);
    }
}

