/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core;

import adams.core.ClassLister;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionUtils;
import adams.gui.visualization.core.MouseMovementTracker;
import adams.gui.visualization.core.PaintablePanel;
import adams.gui.visualization.core.PlotPanel;
import java.awt.Point;
import java.awt.event.MouseEvent;

public abstract class AbstractMouseMovementTracker
extends AbstractOptionHandler
implements MouseMovementTracker {
    private static final long serialVersionUID = -5687969310967552455L;
    protected PaintablePanel m_Panel;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Panel = null;
    }

    @Override
    public void setPanel(PaintablePanel value) {
        if (value != this.m_Panel) {
            this.m_Panel = value;
            if (this.m_Panel != null) {
                Point point = value.getMousePosition();
                if (point == null) {
                    point = new Point(0, 0);
                }
                this.mouseMovementTracked(new MouseEvent(value, 503, System.currentTimeMillis(), 0, point.x, point.y, 0, false));
            }
        }
    }

    @Override
    public PaintablePanel getPanel() {
        return this.m_Panel;
    }

    public boolean hasPanel() {
        return this.m_Panel != null;
    }

    public PlotPanel getPlot() {
        PlotPanel result = null;
        if (this.m_Panel != null) {
            result = this.m_Panel.getPlot();
        }
        return result;
    }

    @Override
    public abstract void mouseMovementTracked(MouseEvent var1);

    public MouseMovementTracker shallowCopy() {
        return this.shallowCopy(false);
    }

    public MouseMovementTracker shallowCopy(boolean expand) {
        return (MouseMovementTracker)((Object)OptionUtils.shallowCopy(this, expand));
    }

    public static String[] getMouseMovementTrackers() {
        return ClassLister.getSingleton().getClassnames(MouseMovementTracker.class);
    }

    public static MouseMovementTracker forName(String classname, String[] options) {
        MouseMovementTracker result;
        try {
            result = (MouseMovementTracker)OptionUtils.forName(MouseMovementTracker.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static MouseMovementTracker forCommandLine(String cmdline) {
        return (MouseMovementTracker)((Object)AbstractOptionConsumer.fromString(ArrayConsumer.class, cmdline));
    }
}

